/*
 * Decompiled with CFR 0.152.
 */
package security.processor;

import framework.config.SecurityConfig;
import framework.security.Account;
import framework.security.AccountLoader;
import framework.security.token.AuthTokenBuilder;
import framework.security.token.AuthTokenInfo;
import framework.utils.JsonUtil;
import framework.vo.ResultInfo;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.stereotype.Component;
import security.vo.LoginInfo;
import security.vo.UserDetail;

@Component
public class AuthSuccessProcessor
implements AuthenticationSuccessHandler {
    private static final Logger log = LoggerFactory.getLogger(AuthSuccessProcessor.class);
    @Autowired
    private AccountLoader accountLoader;
    @Autowired
    private AuthTokenBuilder authTokenBuilder;
    @Autowired
    private SecurityConfig securityConfig;

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        UserDetail detail = (UserDetail)authentication.getPrincipal();
        if (detail == null) {
            throw new UsernameNotFoundException("System error, not found ud");
        }
        Account account = detail.getAccount();
        String token = this.createToken(account.getId());
        this.accountLoader.loginSuccessful(account.getUsername(), Long.valueOf(account.getId()));
        LoginInfo loginInfo = new LoginInfo();
        loginInfo.setId(account.getId());
        loginInfo.setName(account.getName());
        loginInfo.setUsername(account.getUsername());
        loginInfo.setToken(token);
        ResultInfo resultInfo = new ResultInfo((Object)loginInfo);
        String s = JsonUtil.toJsonString((Object)resultInfo);
        response.setContentType("application/json");
        response.setCharacterEncoding(Charset.defaultCharset().displayName());
        response.getWriter().write(s);
    }

    private String createToken(Long userId) {
        Date now = new Date();
        Date expired = new Date(now.getTime() + (long)(this.securityConfig.getTokenSeconds() * 1000));
        String token = this.authTokenBuilder.encode(new AuthTokenInfo(userId, expired));
        return token;
    }
}

