/*
 * Decompiled with CFR 0.152.
 */
package framework.vo;

import com.github.pagehelper.PageInfo;
import framework.vo.ResultInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ResultList<T>
extends ResultInfo<Collection<T>>
implements Serializable {
    private Long total = 0L;
    private Integer pageIndex = 1;
    private Integer pageSize = 10;

    public ResultList() {
        this(new ArrayList());
    }

    public ResultList(String failMessage) {
        super(null);
        super.failed(failMessage);
    }

    public ResultList(Collection<T> data) {
        super(data);
        this.pageIndex = 1;
        this.pageSize = data.size();
        this.total = (long)data.size() + 0L;
    }

    public ResultList(Collection<T> data, long total, int pageIndex, int pageSize) {
        super(data);
        this.total = total;
        this.pageIndex = pageIndex;
        this.pageSize = pageSize;
    }

    public ResultList(int code, String msg) {
        super(code, msg);
    }

    public ResultList(int code, String msg, Collection<T> data) {
        super(code, msg, data);
        this.pageIndex = 1;
        this.pageSize = data.size();
        this.total = (long)data.size() + 0L;
    }

    public ResultList(int code, String msg, Collection<T> data, Long total, Integer pageIndex, Integer pageSize) {
        super(code, msg, data);
        this.total = total;
        this.pageIndex = pageIndex;
        this.pageSize = pageSize;
    }

    public ResultList(int code, Collection<T> data, Long total, Integer pageIndex, Integer pageSize) {
        super(code, data);
        this.total = total;
        this.pageIndex = pageIndex;
        this.pageSize = pageSize;
    }

    public ResultList(PageInfo<T> info) {
        super(info.getList());
        this.total = info.getTotal();
        this.pageIndex = info.getPageNum();
        this.pageSize = info.getPageSize();
    }

    public List<T> dataAsList() {
        if (this.getData() instanceof List) {
            return (List)this.getData();
        }
        return new ArrayList((Collection)this.getData());
    }

    public Long getTotal() {
        return this.total;
    }

    public Integer getPageIndex() {
        return this.pageIndex;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setTotal(Long total) {
        this.total = total;
    }

    public void setPageIndex(Integer pageIndex) {
        this.pageIndex = pageIndex;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResultList)) {
            return false;
        }
        ResultList other = (ResultList)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$total = this.getTotal();
        Long other$total = other.getTotal();
        if (this$total == null ? other$total != null : !((Object)this$total).equals(other$total)) {
            return false;
        }
        Integer this$pageIndex = this.getPageIndex();
        Integer other$pageIndex = other.getPageIndex();
        if (this$pageIndex == null ? other$pageIndex != null : !((Object)this$pageIndex).equals(other$pageIndex)) {
            return false;
        }
        Integer this$pageSize = this.getPageSize();
        Integer other$pageSize = other.getPageSize();
        return !(this$pageSize == null ? other$pageSize != null : !((Object)this$pageSize).equals(other$pageSize));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ResultList;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $total = this.getTotal();
        result = result * 59 + ($total == null ? 43 : ((Object)$total).hashCode());
        Integer $pageIndex = this.getPageIndex();
        result = result * 59 + ($pageIndex == null ? 43 : ((Object)$pageIndex).hashCode());
        Integer $pageSize = this.getPageSize();
        result = result * 59 + ($pageSize == null ? 43 : ((Object)$pageSize).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ResultList(total=" + this.getTotal() + ", pageIndex=" + this.getPageIndex() + ", pageSize=" + this.getPageSize() + ")";
    }
}

