/*
 * Decompiled with CFR 0.152.
 */
package framework.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import framework.utils.JsonUtil;
import framework.utils.WebUtilConfig;
import java.util.Base64;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;

public class WebUtil {
    public static HttpClientBuilder newClient(WebUtilConfig wuc) {
        HttpHost proxyHost = null;
        if (StringUtils.isNotBlank((CharSequence)wuc.getProxyHost())) {
            proxyHost = HttpHost.create((String)wuc.getProxyHost());
        }
        RequestConfig config = RequestConfig.custom().setSocketTimeout(wuc.getReadTimeout()).setConnectTimeout(wuc.getConnectTimeout()).setProxy(proxyHost).build();
        HttpClientBuilder builder = HttpClients.custom();
        builder.setDefaultRequestConfig(config);
        if (wuc.isSkipCertificateVerification()) {
            builder.setSSLHostnameVerifier((hostname, session) -> true);
            builder.setSSLContext(SSLContextBuilder.create().loadTrustMaterial((TrustStrategy)new TrustAllStrategy()).build());
        }
        if (StringUtils.isNotBlank((CharSequence)wuc.getUserAgent())) {
            builder.setUserAgent(wuc.getUserAgent());
        }
        return builder;
    }

    public static void fillHeader(HttpRequestBase request, WebUtilConfig wuc) {
        if (StringUtils.isNotBlank((CharSequence)wuc.getUserAgent())) {
            request.setHeader("User-Agent", wuc.getUserAgent());
        }
        if (StringUtils.isNotBlank((CharSequence)wuc.getAuthorization())) {
            request.setHeader("Authorization", wuc.getAuthorization());
        } else if (StringUtils.isNotBlank((CharSequence)wuc.getUsername()) && StringUtils.isNotBlank((CharSequence)wuc.getPassword())) {
            byte[] authBytes = (wuc.getUsername() + ":" + wuc.getPassword()).getBytes();
            request.setHeader("Authorization", "Basic " + Base64.getEncoder().encodeToString(authBytes));
        }
        if (StringUtils.isNotBlank((CharSequence)wuc.getCharset())) {
            request.setHeader("Accept-Charset", wuc.getCharset());
        }
        if (StringUtils.isNotBlank((CharSequence)wuc.getLanguage())) {
            request.setHeader("Accept-Language", wuc.getLanguage());
        }
        if (StringUtils.isNotBlank((CharSequence)wuc.getCookie())) {
            request.setHeader("Cookie", wuc.getCookie());
        }
    }

    public static String get(String url, WebUtilConfig wuc) {
        byte[] data = WebUtil.getData(url, wuc);
        return new String(data, wuc.getCharset());
    }

    /*
     * Exception decompiling
     */
    public static byte[] getData(String url, WebUtilConfig wuc) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static <T> T getJSON(String url, WebUtilConfig wuc, Class<T> clazz) {
        String s = WebUtil.get(url, wuc);
        return JsonUtil.parse(s, clazz);
    }

    public static <T> T getJSON(String url, WebUtilConfig wuc, TypeReference<T> typeReference) {
        String s = WebUtil.get(url, wuc);
        return JsonUtil.parse(s, typeReference);
    }

    public static String post(String url, WebUtilConfig wuc, List<BasicNameValuePair> formData) {
        byte[] data = WebUtil.postData(url, wuc, formData);
        return new String(data, wuc.getCharset());
    }

    /*
     * Exception decompiling
     */
    public static byte[] postData(String url, WebUtilConfig wuc, List<BasicNameValuePair> formData) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static <T> T postJSON(String url, WebUtilConfig wuc, Class<T> clazz, List<BasicNameValuePair> formData) {
        String s = WebUtil.post(url, wuc, formData);
        return JsonUtil.parse(s, clazz);
    }

    public static <T> T postJSON(String url, WebUtilConfig wuc, TypeReference<T> typeReference, List<BasicNameValuePair> formData) {
        String s = WebUtil.post(url, wuc, formData);
        return JsonUtil.parse(s, typeReference);
    }
}

