/*
 * Decompiled with CFR 0.152.
 */
package framework.utils;

import java.io.File;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.system.ApplicationHome;
import org.springframework.stereotype.Component;

@Component
public class VersionUtil {
    private static final Logger log = LoggerFactory.getLogger(VersionUtil.class);
    private static Date UP_TIME;

    public VersionUtil() {
        UP_TIME = new Date();
    }

    public static String jarVersionString(Class cls) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        return sdf.format(VersionUtil.jarVersion(cls));
    }

    public static Date jarVersion(Class cls) {
        long time = 0L;
        ApplicationHome applicationHome = new ApplicationHome(cls);
        File file = applicationHome.getSource();
        if (file.getName().toLowerCase().endsWith(".jar")) {
            time = file.lastModified();
            Instant instant = Instant.ofEpochMilli(time);
            return Date.from(instant);
        }
        return UP_TIME;
    }

    public static Date getUP_TIME() {
        return UP_TIME;
    }
}

