/*
 * Decompiled with CFR 0.152.
 */
package framework.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VariableUtil {
    private static Pattern camelPattern = Pattern.compile("[A-Z]");

    public static String capitalizeFirstLetter(String str) {
        char firstChar = str.toUpperCase().charAt(0);
        String nextStr = str.toLowerCase().substring(1);
        return firstChar + nextStr;
    }

    public static String capitalizeFirstCharLetter(String str) {
        String firstChar = String.valueOf(str.charAt(0)).toUpperCase();
        String nextStr = str.substring(1);
        return firstChar + nextStr;
    }

    public static String lowercaseFirstCharLetter(String str) {
        String firstChar = String.valueOf(str.charAt(0)).toLowerCase();
        String nextStr = str.substring(1);
        return firstChar + nextStr;
    }

    public static String underlineToCamel(String str) {
        String[] items = str.split("_|\\-|\\.");
        StringBuilder builder = new StringBuilder();
        String firstStr = "";
        String tempStr = "";
        for (int i = 0; i < items.length; ++i) {
            if (i == 0) {
                firstStr = items[0].toLowerCase();
                builder.append(firstStr);
                continue;
            }
            tempStr = VariableUtil.capitalizeFirstLetter(items[i]);
            builder.append(tempStr);
        }
        return builder.toString();
    }

    public static String camelToUnderline(String humpStr) {
        boolean fullUpperCase = false;
        boolean wordFirstUpperCase = false;
        return VariableUtil.camelToUnderline(humpStr, fullUpperCase, wordFirstUpperCase);
    }

    public static String camelToUnderline(String humpStr, boolean fullUpperCase, boolean wordFirstUpperCase) {
        Matcher matcher = camelPattern.matcher(humpStr);
        StringBuffer builder = new StringBuffer();
        while (matcher.find()) {
            if (wordFirstUpperCase) {
                matcher.appendReplacement(builder, "_" + VariableUtil.capitalizeFirstLetter(matcher.group(0).toLowerCase()));
                continue;
            }
            matcher.appendReplacement(builder, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(builder);
        if (fullUpperCase) {
            return builder.toString().toUpperCase();
        }
        if (wordFirstUpperCase) {
            return VariableUtil.capitalizeFirstCharLetter(builder.toString());
        }
        return builder.toString();
    }
}

