/*
 * Decompiled with CFR 0.152.
 */
package framework.utils;

import framework.utils.IdUtil;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.springframework.util.Assert;

public class Skip32Util {
    private static final int[] FTABLE = new int[]{163, 215, 9, 131, 248, 72, 246, 244, 179, 33, 21, 120, 153, 177, 175, 249, 231, 45, 77, 138, 206, 76, 202, 46, 82, 149, 217, 30, 78, 56, 68, 40, 10, 223, 2, 160, 23, 241, 96, 104, 18, 183, 122, 195, 233, 250, 61, 83, 150, 132, 107, 186, 242, 99, 154, 25, 124, 174, 229, 245, 247, 22, 106, 162, 57, 182, 123, 15, 193, 147, 129, 27, 238, 180, 26, 234, 208, 145, 47, 184, 85, 185, 218, 133, 63, 65, 191, 224, 90, 88, 128, 95, 102, 11, 216, 144, 53, 213, 192, 167, 51, 6, 101, 105, 69, 0, 148, 86, 109, 152, 155, 118, 151, 252, 178, 194, 176, 254, 219, 32, 225, 235, 214, 228, 221, 71, 74, 29, 66, 237, 158, 110, 73, 60, 205, 67, 39, 210, 7, 212, 222, 199, 103, 24, 137, 203, 48, 31, 141, 198, 143, 170, 200, 116, 220, 201, 93, 92, 49, 164, 112, 136, 97, 44, 159, 13, 43, 135, 80, 130, 84, 100, 38, 125, 3, 64, 52, 75, 28, 115, 209, 196, 253, 59, 204, 251, 127, 171, 230, 62, 91, 165, 173, 4, 35, 156, 20, 81, 34, 240, 41, 121, 113, 126, 255, 140, 14, 226, 12, 239, 188, 114, 117, 111, 55, 161, 236, 211, 142, 98, 139, 134, 16, 232, 8, 119, 17, 190, 146, 79, 36, 197, 50, 54, 157, 207, 243, 166, 187, 172, 94, 108, 169, 19, 87, 37, 181, 227, 189, 168, 58, 1, 5, 89, 42, 70};

    private static int g(byte[] key, int k, int w) {
        int g1 = w >> 8;
        int g2 = w & 0xFF;
        int g3 = FTABLE[g2 ^ key[4 * k % 10] & 0xFF] ^ g1;
        int g4 = FTABLE[g3 ^ key[(4 * k + 1) % 10] & 0xFF] ^ g2;
        int g5 = FTABLE[g4 ^ key[(4 * k + 2) % 10] & 0xFF] ^ g3;
        int g6 = FTABLE[g5 ^ key[(4 * k + 3) % 10] & 0xFF] ^ g4;
        return (g5 << 8) + g6;
    }

    public static void skip32(byte[] key, int[] buf, boolean encrypt) {
        int k;
        int kstep;
        if (encrypt) {
            kstep = 1;
            k = 0;
        } else {
            kstep = -1;
            k = 23;
        }
        int wl = (buf[0] << 8) + buf[1];
        int wr = (buf[2] << 8) + buf[3];
        for (int i = 0; i < 12; ++i) {
            wr ^= Skip32Util.g(key, k, wl) ^ k;
            wl ^= Skip32Util.g(key, k += kstep, wr) ^ k;
            k += kstep;
        }
        buf[0] = wr >> 8;
        buf[1] = wr & 0xFF;
        buf[2] = wl >> 8;
        buf[3] = wl & 0xFF;
    }

    public static int encrypt(int value, byte[] key) {
        int[] buf = new int[]{value >> 24 & 0xFF, value >> 16 & 0xFF, value >> 8 & 0xFF, value >> 0 & 0xFF};
        Skip32Util.skip32(key, buf, true);
        int out = buf[0] << 24 | buf[1] << 16 | buf[2] << 8 | buf[3];
        return out;
    }

    public static int decrypt(int value, byte[] key) {
        int[] buf = new int[]{value >> 24 & 0xFF, value >> 16 & 0xFF, value >> 8 & 0xFF, value >> 0 & 0xFF};
        Skip32Util.skip32(key, buf, false);
        int out = buf[0] << 24 | buf[1] << 16 | buf[2] << 8 | buf[3];
        return out;
    }

    private static int extractLast4Bytes(long value) {
        byte[] bytes = ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN).putLong(value).array();
        return ByteBuffer.wrap(new byte[]{bytes[5], bytes[7], bytes[2], bytes[3]}).getInt();
    }

    private static long combine(long original, int newLower32) {
        byte[] originalBytes = ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN).putLong(original).array();
        byte[] newLowerBytes = ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(newLower32).array();
        originalBytes[5] = newLowerBytes[0];
        originalBytes[7] = newLowerBytes[1];
        originalBytes[2] = newLowerBytes[2];
        originalBytes[3] = newLowerBytes[3];
        return ByteBuffer.wrap(originalBytes).getLong();
    }

    public static long partEncrypt(long value, byte[] key) {
        int lower32 = Skip32Util.extractLast4Bytes(value);
        int encrypted = Skip32Util.encrypt(lower32, key);
        return Skip32Util.combine(value, encrypted);
    }

    public static long partDecrypt(long encrypted, byte[] key) {
        int lower32 = Skip32Util.extractLast4Bytes(encrypted);
        int decrypted = Skip32Util.decrypt(lower32, key);
        return Skip32Util.combine(encrypted, decrypted);
    }

    public static void main(String[] args) {
        byte[] key = new byte[]{17, 34, 51, 68, 85, 102, 119, 8, 9, 10};
        int original = 12345678;
        int encrypted = Skip32Util.encrypt(original, key);
        int decrypted = Skip32Util.decrypt(encrypted, key);
        System.out.println("Original: " + original);
        System.out.println("Encrypted: " + encrypted);
        System.out.println("Decrypted: " + decrypted);
        Assert.isTrue((original == decrypted ? 1 : 0) != 0, (String)"Skip32 test failed");
        Long l = IdUtil.newId();
        Long s = Skip32Util.partEncrypt(l, key);
        Long d = Skip32Util.partDecrypt(s, key);
        System.out.printf("%d, %d, %d, %d, %d\n", l, l.toString().length(), s, s.toString().length(), d);
        Assert.isTrue((boolean)l.equals(d), (String)"Skip32 encrypt failed");
        l = IdUtil.newId();
        s = Skip32Util.partEncrypt(l, key);
        d = Skip32Util.partDecrypt(s, key);
        System.out.printf("%d, %d, %d, %d, %d\n", l, l.toString().length(), s, s.toString().length(), d);
        Assert.isTrue((boolean)l.equals(d), (String)"Skip32 encrypt failed");
        l = IdUtil.newId();
        s = Skip32Util.partEncrypt(l, key);
        d = Skip32Util.partDecrypt(s, key);
        System.out.printf("%d, %d, %d, %d, %d\n", l, l.toString().length(), s, s.toString().length(), d);
        Assert.isTrue((boolean)l.equals(d), (String)"Skip32 encrypt failed");
        l = IdUtil.newId();
        s = Skip32Util.partEncrypt(l, key);
        d = Skip32Util.partDecrypt(s, key);
        System.out.printf("%d, %d, %d, %d, %d\n", l, l.toString().length(), s, s.toString().length(), d);
        Assert.isTrue((boolean)l.equals(d), (String)"Skip32 encrypt failed");
        l = IdUtil.newId();
        s = Skip32Util.partEncrypt(l, key);
        d = Skip32Util.partDecrypt(s, key);
        System.out.printf("%d, %d, %d, %d, %d\n", l, l.toString().length(), s, s.toString().length(), d);
        Assert.isTrue((boolean)l.equals(d), (String)"Skip32 encrypt failed");
    }
}

