/*
 * Decompiled with CFR 0.152.
 */
package framework.utils;

import framework.utils.ConvertUtil;
import framework.utils.StringUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ServletUtil {
    public static String getParameter(String name) {
        return ServletUtil.getRequest().getParameter(name);
    }

    public static String getParameter(String name, String defaultValue) {
        String s = StringUtil.objectToString((Object)ServletUtil.getRequest().getParameter(name), defaultValue);
        return s;
    }

    public static Integer getInteger(String name) {
        HttpServletRequest request = ServletUtil.getRequest();
        Integer parameter = ServletRequestUtils.getIntParameter((ServletRequest)request, (String)name);
        return parameter;
    }

    public static Integer getInteger(String name, Integer defaultValue) {
        HttpServletRequest request = ServletUtil.getRequest();
        int v = ServletRequestUtils.getIntParameter((ServletRequest)request, (String)name, (int)defaultValue);
        return v;
    }

    public static Long getLong(String name) {
        HttpServletRequest request = ServletUtil.getRequest();
        Long parameter = ServletRequestUtils.getLongParameter((ServletRequest)request, (String)name);
        return parameter;
    }

    public static Long getLong(String name, Long defaultValue) {
        HttpServletRequest request = ServletUtil.getRequest();
        Long parameter = ServletRequestUtils.getLongParameter((ServletRequest)request, (String)name, (long)defaultValue);
        return parameter;
    }

    public static Boolean getBoolean(String name) {
        String p = ServletUtil.getParameter(name);
        boolean b = ConvertUtil.toBoolean(p);
        return b;
    }

    public static Boolean getBoolean(String name, Boolean defaultValue) {
        String p = ServletUtil.getParameter(name);
        if (!StringUtils.hasText((String)p)) {
            return defaultValue;
        }
        boolean b = ConvertUtil.toBoolean(p);
        return b;
    }

    public static HttpServletRequest getRequest() {
        return ServletUtil.getRequestAttributes().getRequest();
    }

    public static HttpServletResponse getResponse() {
        return ServletUtil.getRequestAttributes().getResponse();
    }

    public static HttpSession getSession() {
        return ServletUtil.getRequest().getSession();
    }

    public static ServletRequestAttributes getRequestAttributes() {
        RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
        return (ServletRequestAttributes)attributes;
    }

    public static String WriteJsonString(HttpServletResponse response, String string) {
        try {
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            response.getWriter().print(string);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String urlEncode(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String urlDecode(String str) {
        try {
            return URLDecoder.decode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }
}

