/*
 * Decompiled with CFR 0.152.
 */
package framework.utils;

import framework.client.WebUserAgent;
import framework.runtime.SystemContext;
import framework.utils.ServletUtil;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.springframework.context.NoSuchMessageException;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public final class RequestUtil {
    public static RequestAttributes getAttributes() {
        RequestAttributes attributes = RequestContextHolder.currentRequestAttributes();
        return attributes;
    }

    public static void setAttribute(String name, String obj) {
        RequestUtil.getAttributes().setAttribute(name, (Object)obj, 0);
    }

    public static Object getAttribute(String name) {
        Object obj = RequestUtil.getAttributes().getAttribute(name, 0);
        if (obj == null) {
            return null;
        }
        return obj;
    }

    public static WebUserAgent getUserAgent() {
        HttpServletRequest request = ServletUtil.getRequest();
        return new WebUserAgent(request);
    }

    public static String getBrowser() {
        return RequestUtil.getUserAgent().getBrowser();
    }

    public static String getOS() {
        return RequestUtil.getUserAgent().getOs();
    }

    public static String getClientIp() {
        HttpServletRequest request = ServletUtil.getRequest();
        if (request != null) {
            return RequestUtil.getClientIp(request);
        }
        return "unknown";
    }

    public static String getHeader(String name) {
        HttpServletRequest request = ServletUtil.getRequest();
        if (request != null) {
            return request.getHeader(name);
        }
        return "unknown";
    }

    public static String getClientIp(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip != null && ip.length() > 0 && !"unknown".equalsIgnoreCase(ip)) {
            return ip.split(",")[0].trim();
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public static boolean isAjaxRequest(HttpServletRequest request) {
        String accept = request.getHeader("accept");
        if (accept != null && accept.contains("application/json")) {
            return true;
        }
        String xRequestedWith = request.getHeader("X-Requested-With");
        if (xRequestedWith != null && xRequestedWith.contains("XMLHttpRequest")) {
            return true;
        }
        String uri = request.getRequestURI();
        if (uri.endsWith(".json")) {
            return true;
        }
        return uri.endsWith(".xml");
    }

    public static String getMessage(String code, Object ... args) throws NoSuchMessageException {
        HttpServletRequest request = ServletUtil.getRequest();
        Locale locale = request.getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        String message = SystemContext.getMessage(code, args, locale);
        return message;
    }

    public static String getMessageDefault(String code, String defaultMessage, Object ... args) throws NoSuchMessageException {
        HttpServletRequest request = ServletUtil.getRequest();
        Locale locale = request.getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        String message = SystemContext.getMessage(code, args, defaultMessage, locale);
        return message;
    }
}

