/*
 * Decompiled with CFR 0.152.
 */
package framework.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import framework.exceptions.JsonException;
import java.io.IOException;
import java.text.DateFormat;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.springframework.util.StringUtils;

public class JsonUtil {
    public static final List<Module> customModules = new CopyOnWriteArrayList<Module>();
    public static ObjectMapper mapper = JsonUtil.newMapper(false);

    public static ObjectMapper newMapper() {
        return JsonUtil.newMapper(false);
    }

    public static ObjectMapper newMapper(boolean registerJavaTime) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        if (registerJavaTime) {
            mapper.registerModule((Module)new JavaTimeModule());
        }
        for (Module module : customModules) {
            mapper.registerModule(module);
        }
        return mapper;
    }

    public static <T> String toJsonString(T obj) {
        return JsonUtil.toJsonString(obj, true);
    }

    public static <T> String toJsonString(T obj, boolean pretty) {
        if (Objects.isNull(obj)) {
            return null;
        }
        try {
            return pretty ? mapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj) : mapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new JsonException("Parse Object to String error", e);
        }
    }

    public static <T> String toJsonString(T obj, DateFormat dateFormat) {
        return JsonUtil.toJsonString(obj, dateFormat, true);
    }

    public static <T> String toJsonString(T obj, DateFormat dateFormat, boolean pretty) {
        String s;
        ObjectMapper mapper = JsonUtil.newMapper();
        mapper.setDateFormat(dateFormat);
        try {
            s = pretty ? mapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj) : mapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new JsonException("Parse Object to String error", e);
        }
        return s;
    }

    public static <T> T parse(String text, Class<T> clazz) {
        if (!StringUtils.hasText((String)text)) {
            return null;
        }
        if (clazz == null) {
            return null;
        }
        if (clazz.equals(String.class)) {
            return null;
        }
        try {
            return (T)mapper.readValue(text, clazz);
        }
        catch (IOException e) {
            throw new JsonException("Parse String to Object error", e);
        }
    }

    public static <T> T parse(String text, TypeReference<T> typeReference) {
        if (!StringUtils.hasText((String)text)) {
            return null;
        }
        if (typeReference == null) {
            return null;
        }
        try {
            return (T)mapper.readValue(text, typeReference);
        }
        catch (IOException e) {
            throw new JsonException("Parse String to Object error", e);
        }
    }

    public static <T> T parse(String text) {
        if (!StringUtils.hasText((String)text)) {
            return null;
        }
        try {
            return (T)mapper.readValue(text, new TypeReference<T>(){});
        }
        catch (IOException e) {
            throw new JsonException("Parse String to Object error", e);
        }
    }

    public static <T> List<T> parseArray(String text, Class<T> clazz) {
        if (!StringUtils.hasText((String)text) || clazz == null) {
            return null;
        }
        JavaType javaType = mapper.getTypeFactory().constructParametricType(List.class, new Class[]{clazz});
        try {
            return (List)mapper.readValue(text, javaType);
        }
        catch (IOException e) {
            throw new JsonException("Parse String to Array error", e);
        }
    }

    public static <T> T parse(String text, DateFormat dateFormat) {
        if (!StringUtils.hasText((String)text)) {
            return null;
        }
        ObjectMapper mapper = JsonUtil.newMapper();
        mapper.setDateFormat(dateFormat);
        try {
            return (T)mapper.readValue(text, new TypeReference<T>(){});
        }
        catch (IOException e) {
            throw new JsonException("Parse String to Object error", e);
        }
    }

    public static <T> T parse(String text, DateFormat dateFormat, TypeReference<T> typeReference) {
        if (!StringUtils.hasText((String)text)) {
            return null;
        }
        ObjectMapper mapper = JsonUtil.newMapper();
        mapper.setDateFormat(dateFormat);
        try {
            return (T)mapper.readValue(text, typeReference);
        }
        catch (IOException e) {
            throw new JsonException("Parse String to Object error", e);
        }
    }

    public static <T> List<T> parseArray(String text, DateFormat dateFormat, Class<T> clazz) {
        if (!StringUtils.hasText((String)text) || clazz == null) {
            return null;
        }
        ObjectMapper mapper = JsonUtil.newMapper();
        mapper.setDateFormat(dateFormat);
        JavaType javaType = mapper.getTypeFactory().constructParametricType(List.class, new Class[]{clazz});
        try {
            return (List)mapper.readValue(text, javaType);
        }
        catch (IOException e) {
            throw new JsonException("Parse String to Array error", e);
        }
    }
}

