/*
 * Decompiled with CFR 0.152.
 */
package framework.utils;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.codec.binary.Base64;

public class ImageUtil {
    public static String encodeImageToBase64(URL url) throws IOException {
        HttpURLConnection conn = null;
        conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setConnectTimeout(5000);
        byte[] data = null;
        try (InputStream inStream = conn.getInputStream();
             ByteArrayOutputStream outStream = new ByteArrayOutputStream();){
            byte[] buffer = new byte[8192];
            int len = 0;
            while ((len = inStream.read(buffer)) != -1) {
                outStream.write(buffer, 0, len);
            }
            data = outStream.toByteArray();
        }
        return Base64.encodeBase64String((byte[])data);
    }

    public static boolean generateImage(String imgStr, String imgFilePath) {
        if (imgStr == null) {
            return false;
        }
        try {
            byte[] b = Base64.decodeBase64((String)imgStr);
            for (int i = 0; i < b.length; ++i) {
                if (b[i] >= 0) continue;
                int n = i;
                b[n] = (byte)(b[n] + 256);
            }
            try (FileOutputStream out = new FileOutputStream(imgFilePath);){
                ((OutputStream)out).write(b);
                out.flush();
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String imageToBase64(InputStream in) {
        byte[] data = null;
        try {
            data = new byte[in.available()];
            in.read(data);
        }
        catch (IOException exception) {
            data = new byte[]{};
            exception.printStackTrace();
        }
        return new String(Base64.encodeBase64((byte[])data));
    }
}

