/*
 * Decompiled with CFR 0.152.
 */
package framework.utils;

import framework.exceptions.BusinessException;
import framework.exceptions.Error400Exception;
import framework.exceptions.Error401Exception;
import framework.exceptions.Error403Exception;
import framework.exceptions.Error404Exception;
import framework.exceptions.Error405Exception;
import framework.exceptions.WebException;
import framework.utils.RequestUtil;
import java.util.ArrayList;
import org.springframework.util.StringUtils;

public class ErrorUtil {
    public static Throwable getCause(Throwable e) {
        Throwable cause1 = e;
        Throwable cause2 = e;
        while ((cause2 = cause1.getCause()) != null) {
            cause1 = cause2;
        }
        return cause1;
    }

    public static String getNullTrace(NullPointerException e) {
        return ErrorUtil.getNullTrace(e, 5);
    }

    public static String getNullTrace(NullPointerException e, int level) {
        ArrayList<String> items = new ArrayList<String>();
        StackTraceElement[] stackTrace = e.getStackTrace();
        if (stackTrace != null && stackTrace.length > 0) {
            for (int i = 0; i < level && stackTrace.length > i; ++i) {
                items.add(stackTrace[i].getFileName() + ":" + stackTrace[i].getLineNumber());
            }
        }
        return String.join((CharSequence)",", items);
    }

    public static void badRequest() throws Error400Exception {
        String message = RequestUtil.getMessageDefault("error.e400", "Bad Request", new Object[0]);
        throw new Error400Exception(message);
    }

    public static void badRequest(String message) throws Error400Exception {
        throw new Error400Exception(message);
    }

    public static void noAuthorization() throws Error401Exception {
        String message = RequestUtil.getMessageDefault("error.e401", "Unauthorized", new Object[0]);
        throw new Error401Exception(message);
    }

    public static void noAuthorization(String message) throws Error401Exception {
        throw new Error401Exception(message);
    }

    public static void forbidden() throws Error403Exception {
        String message = RequestUtil.getMessageDefault("error.e403", "Forbidden", new Object[0]);
        throw new Error403Exception(message);
    }

    public static void forbidden(String message) throws Error403Exception {
        throw new Error403Exception(message);
    }

    public static void notFound() throws Error404Exception {
        String message = RequestUtil.getMessageDefault("error.e404", "Not found", new Object[0]);
        throw new Error404Exception(message);
    }

    public static void notFound(String message) throws Error404Exception {
        throw new Error404Exception(message);
    }

    public static void noAccess() throws Error405Exception {
        String message = RequestUtil.getMessageDefault("error.e405", "No Access", new Object[0]);
        throw new Error405Exception(message);
    }

    public static void noAccess(String message) throws Error405Exception {
        throw new Error405Exception(message);
    }

    public static void serverError() throws WebException {
        String message = RequestUtil.getMessageDefault("error.e500", "Server error", new Object[0]);
        throw new WebException(message);
    }

    public static void serverError(String message) throws WebException {
        throw new WebException(message);
    }

    public static void error(String message) throws BusinessException {
        throw new BusinessException(message);
    }

    public static void error(String i18n, String defaultMessage) throws BusinessException {
        String message = RequestUtil.getMessageDefault(i18n, defaultMessage, new Object[0]);
        throw new BusinessException(message);
    }

    public static void error(String i18n, String defaultMessage, Object ... args) throws BusinessException {
        String message = StringUtils.hasText((String)defaultMessage) ? RequestUtil.getMessageDefault(i18n, defaultMessage, args) : RequestUtil.getMessage(i18n, args);
        throw new BusinessException(message);
    }
}

