/*
 * Decompiled with CFR 0.152.
 */
package framework.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.springframework.util.StringUtils;

public class DateUtil {
    public static final ZonedDateTime MAX_UTC_TIME = ZonedDateTime.of(9999, 1, 1, 0, 0, 0, 0, ZoneId.of("UTC"));
    public static final LocalDateTime MAX_LOCAL_TIME = LocalDateTime.of(9999, 1, 1, 0, 0, 0, 0);
    public static final String FORMAT_MILLI_ZONE = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final String FORMAT_ZONE = "yyyy-MM-dd'T'HH:mm:ssZ";
    public static final String FORMAT_TIME = "yyyy-MM-dd HH:mm:ss";
    public static final String FORMAT_DATE = "yyyy-MM-dd";

    public static Date getGMTString(String str, String dateFormat) {
        SimpleDateFormat format = new SimpleDateFormat(dateFormat);
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            return format.parse(str);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static Date tryDate(String str, String dateFormat, String timeZone) {
        SimpleDateFormat format = new SimpleDateFormat(dateFormat);
        if (StringUtils.hasText((String)timeZone)) {
            format.setTimeZone(TimeZone.getTimeZone(timeZone));
        }
        try {
            return format.parse(str);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static Date tryUTCDate(String str, String dateFormat) {
        return DateUtil.tryDate(str, dateFormat, "UTC");
    }

    public static Date tryUTCDateOrNow(String str, String dateFormat) {
        Date date = DateUtil.tryDate(str, dateFormat, "UTC");
        if (date == null) {
            return new Date();
        }
        return date;
    }

    public static Date tryDateOrNow(String str, String dateFormat, String timeZone) {
        Date date = DateUtil.tryDate(str, dateFormat, timeZone);
        if (date == null) {
            return new Date();
        }
        return date;
    }

    public static String getNowString(String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.format(new Date());
    }

    public static Date stringToDate(String dateStr, String format) {
        if (!StringUtils.hasText((String)format)) {
            format = FORMAT_TIME;
        }
        if (StringUtils.hasLength((String)dateStr)) {
            try {
                return new SimpleDateFormat(format).parse(dateStr);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static Date getDate(Date date, int num) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, num);
        Date time = calendar.getTime();
        return time;
    }

    public static boolean dayComparePrecise(Date fromDate, Date toDate) {
        boolean flag = true;
        Calendar from = Calendar.getInstance();
        from.setTime(fromDate);
        Calendar to = Calendar.getInstance();
        to.setTime(toDate);
        int fromYear = from.get(1);
        int fromMonth = from.get(2);
        int fromDay = from.get(5);
        int toYear = to.get(1);
        int toMonth = to.get(2);
        int toDay = to.get(5);
        int year = toYear - fromYear;
        int month = toMonth - fromMonth;
        int day = toDay - fromDay;
        if (year < 1 || year == 1 && month == 0 && day == 0) {
            flag = false;
        }
        return flag;
    }
}

