/*
 * Decompiled with CFR 0.152.
 */
package framework.utils;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class ClassResourceUtil {
    public static List<String> searchResources(String pattern) throws IOException {
        return ClassResourceUtil.searchResources(pattern, null);
    }

    public static List<String> searchResources(String pattern, String dirname) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        String p0 = null;
        if (StringUtils.isNotBlank((CharSequence)dirname)) {
            URL dirPath = ClassLoader.getSystemResource(dirname);
            if (dirPath == null) {
                throw new IOException("Not found dir name " + dirname);
            }
            p0 = dirPath.getPath();
        }
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        Resource[] resources = resolver.getResources("classpath*:" + pattern);
        if (p0 == null) {
            for (Resource resource : resources) {
                list.add(resource.getURL().getPath());
            }
        } else {
            for (Resource resource : resources) {
                String p1 = resource.getURL().getPath();
                if (!p1.startsWith(p0)) continue;
                list.add(p1.substring(p0.length()));
            }
        }
        return list;
    }
}

