/*
 * Decompiled with CFR 0.152.
 */
package framework.utils;

import framework.units.BaseCoder;
import framework.utils.IdUtil;
import framework.utils.UUIDUtil;
import java.util.UUID;

public class Base58Util {
    public static final String CHARS = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz";
    private static final BaseCoder CODER = new BaseCoder("123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz");

    public static String encode(long number) {
        return CODER.encode(number);
    }

    public static String newId() {
        return CODER.encode(IdUtil.newId());
    }

    public static long decode(String encoded) {
        return CODER.decode(encoded);
    }

    public static String encodeBytes(byte[] input) {
        return CODER.bytesEncode(input);
    }

    public static byte[] decodeBytes(String encoded) {
        return CODER.bytesDecode(encoded);
    }

    public static void main(String[] args) {
        long timestamp = System.currentTimeMillis() / 1000L;
        System.out.println("\u539f\u59cb\u65f6\u95f4\u6233: " + timestamp);
        String encoded = Base58Util.encode(timestamp);
        System.out.println("Base32\u7f16\u7801: " + encoded);
        long decoded = Base58Util.decode(encoded);
        System.out.println("\u89e3\u7801\u7ed3\u679c: " + decoded);
        long id = IdUtil.newId();
        String eid = CODER.encode(id);
        System.out.println("ID: " + id);
        System.out.println("\u7f16\u7801: " + eid);
        System.out.println("\u89e3\u7801: " + Base58Util.decode(eid));
        UUID uuid = UUID.randomUUID();
        System.out.println("ID: " + uuid);
        byte[] bytes = UUIDUtil.toBytes(uuid);
        String encodedBytes = Base58Util.encodeBytes(bytes);
        System.out.println("\u7b26\u53f7: " + uuid.toString().replace("-", ""));
        System.out.println("\u7f16\u7801: " + encodedBytes);
        byte[] decodedBytes = Base58Util.decodeBytes(encodedBytes);
        UUID decodedUuid = UUIDUtil.fromBytes(decodedBytes);
        System.out.println("\u89e3\u7801: " + decodedUuid);
    }
}

