/*
 * Decompiled with CFR 0.152.
 */
package framework.units;

import framework.utils.UUIDUtil;
import java.math.BigInteger;
import java.util.UUID;

public class BaseCoder {
    private final char[] CHARS;

    public BaseCoder(String CHARS) {
        if (CHARS == null || CHARS.length() < 2) {
            throw new IllegalArgumentException("baseChars length must > 1");
        }
        this.CHARS = CHARS.toCharArray();
    }

    public String encode(long number) {
        if (number == 0L) {
            return String.valueOf(this.CHARS[0]);
        }
        StringBuilder sb = new StringBuilder();
        while (number > 0L) {
            int remainder = (int)(number % (long)this.CHARS.length);
            sb.append(this.CHARS[remainder]);
            number /= (long)this.CHARS.length;
        }
        return sb.reverse().toString();
    }

    public long decode(String encoded) {
        long result = 0L;
        for (int i = 0; i < encoded.length(); ++i) {
            char c = encoded.charAt(i);
            int digit = this.indexOf(c);
            if (digit == -1) {
                throw new IllegalArgumentException("invalid chars: " + c);
            }
            result = result * (long)this.CHARS.length + (long)digit;
        }
        return result;
    }

    private int indexOf(char c) {
        for (int i = 0; i < this.CHARS.length; ++i) {
            if (this.CHARS[i] != c) continue;
            return i;
        }
        return -1;
    }

    public String bytesEncode(byte[] input) {
        if (input.length == 0) {
            return "";
        }
        BigInteger baseValue = BigInteger.valueOf(this.CHARS.length);
        BigInteger value = new BigInteger(1, input);
        StringBuilder sb = new StringBuilder();
        while (value.compareTo(BigInteger.ZERO) > 0) {
            BigInteger[] divmod = value.divideAndRemainder(baseValue);
            sb.insert(0, this.CHARS[divmod[1].intValue()]);
            value = divmod[0];
        }
        for (byte b : input) {
            if (b != 0) break;
            sb.insert(0, this.CHARS[0]);
        }
        return sb.toString();
    }

    public byte[] bytesDecode(String input) {
        if (input.isEmpty()) {
            return new byte[0];
        }
        BigInteger value = BigInteger.ZERO;
        BigInteger baseValue = BigInteger.valueOf(this.CHARS.length);
        for (char c : input.toCharArray()) {
            int digit = this.indexOf(c);
            if (digit == -1) {
                throw new IllegalArgumentException("Invalid Base58 character: " + c);
            }
            value = value.multiply(baseValue).add(BigInteger.valueOf(digit));
        }
        byte[] bytes = value.toByteArray();
        if (bytes.length > 1 && bytes[0] == 0) {
            byte[] tmp = new byte[bytes.length - 1];
            System.arraycopy(bytes, 1, tmp, 0, tmp.length);
            bytes = tmp;
        }
        int leadingZeros = 0;
        for (char c : input.toCharArray()) {
            if (c != this.CHARS[0]) break;
            ++leadingZeros;
        }
        if (leadingZeros > 0) {
            byte[] tmp = new byte[bytes.length + leadingZeros];
            System.arraycopy(bytes, 0, tmp, leadingZeros, bytes.length);
            bytes = tmp;
        }
        return bytes;
    }

    public static void main(String[] args) {
        BaseCoder coder = new BaseCoder("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz");
        long timestamp = System.currentTimeMillis() / 1000L;
        System.out.println("\u539f\u59cb\u65f6\u95f4\u6233: " + timestamp);
        String encoded = coder.encode(timestamp);
        System.out.println("Base62\u7f16\u7801: " + encoded);
        long decoded = coder.decode(encoded);
        System.out.println("\u89e3\u7801\u7ed3\u679c: " + decoded);
        UUID uuid = UUID.randomUUID();
        System.out.println("UUID: " + uuid);
        byte[] bytes = UUIDUtil.toBytes(uuid);
        encoded = coder.bytesEncode(bytes);
        System.out.println("\u7f16\u7801: " + encoded);
        bytes = coder.bytesDecode(encoded);
        System.out.println("\u89e3\u7801: " + UUIDUtil.fromBytes(bytes));
    }
}

