/*
 * Decompiled with CFR 0.152.
 */
package framework.storage;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import framework.config.S3Config;
import framework.io.FullBufferOutputStream;
import framework.storage.FileStorage;
import framework.storage.FileStorageS3OutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;

public class FileStorageS3v1
implements FileStorage {
    private S3Config config;
    private AmazonS3 s3;

    public FileStorageS3v1(S3Config config) {
        this.config = config;
        this.s3 = this.s3init();
    }

    @Override
    public String[] compressionPathStarts() {
        return this.getConfig().getCompressPathStarts();
    }

    protected AmazonS3 s3init() {
        ClientConfiguration config = new ClientConfiguration();
        AwsClientBuilder.EndpointConfiguration endpointConfig = new AwsClientBuilder.EndpointConfiguration(this.getConfig().getEndPoint(), this.config.getRegion());
        BasicAWSCredentials awsCredentials = new BasicAWSCredentials(this.config.getAccessKey(), this.config.getSecretKey());
        AWSStaticCredentialsProvider awsCredentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)awsCredentials);
        AmazonS3 s3 = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3Client.builder().withEndpointConfiguration(endpointConfig)).withClientConfiguration(config)).withCredentials((AWSCredentialsProvider)awsCredentialsProvider)).withChunkedEncodingDisabled(Boolean.valueOf(!Objects.equals(true, this.config.getChunkedEncoding())))).withPathStyleAccessEnabled(this.config.getPathStyle())).build();
        return s3;
    }

    @Override
    public long save(InputStream inputStream, String filePath, boolean compression) throws IOException {
        if (compression) {
            filePath = filePath + ".gz";
        }
        Integer partSize = this.getConfig().getPartSize();
        String bucket = this.getConfig().getBucket();
        ObjectMetadata objectMetadata = new ObjectMetadata();
        long sl = 0L;
        try (FileStorageS3OutputStream os0 = new FileStorageS3OutputStream(this.getS3(), bucket, filePath, objectMetadata, partSize.intValue());){
            try (FullBufferOutputStream os1 = new FullBufferOutputStream(os0, partSize);){
                if (compression) {
                    try (GZIPOutputStream os2 = new GZIPOutputStream(os1);){
                        sl = IOUtils.copyLarge((InputStream)inputStream, (OutputStream)os2);
                        ((OutputStream)os2).flush();
                    }
                } else {
                    sl = IOUtils.copyLarge((InputStream)inputStream, (OutputStream)os1);
                }
                ((OutputStream)os1).flush();
            }
            os0.flush();
            os0.setWriteCompleted(true);
            long l = sl;
            return l;
        }
    }

    @Override
    public InputStream getStream(String filePath, boolean compression) throws IOException {
        S3ObjectInputStream objectContent;
        if (compression) {
            filePath = filePath + ".gz";
        }
        try {
            S3Object object = this.getS3().getObject(this.getConfig().getBucket(), filePath);
            objectContent = object.getObjectContent();
        }
        catch (AmazonS3Exception exception) {
            if (exception.getStatusCode() == 404) {
                throw new FileNotFoundException("File not found (" + exception.getMessage() + ")");
            }
            throw new IOException("File not found", exception);
        }
        return compression ? new GZIPInputStream((InputStream)objectContent) : objectContent;
    }

    @Override
    public void delete(String filePath, boolean compression) throws IOException {
        if (compression) {
            filePath = filePath + ".gz";
        }
        this.getS3().deleteObject(this.getConfig().getBucket(), filePath);
    }

    @Override
    public long length(String filePath, boolean compression) throws IOException {
        if (compression) {
            filePath = filePath + ".gz";
        }
        try {
            ObjectMetadata metadata = this.getS3().getObjectMetadata(this.getConfig().getBucket(), filePath);
            return metadata.getContentLength();
        }
        catch (AmazonS3Exception exception) {
            if (exception.getStatusCode() == 404) {
                return -1L;
            }
            throw new IOException("File not found", exception);
        }
    }

    public S3Config getConfig() {
        return this.config;
    }

    public AmazonS3 getS3() {
        return this.s3;
    }
}

