/*
 * Decompiled with CFR 0.152.
 */
package framework.storage;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class FileStorageS3OutputStream
extends OutputStream {
    private final long PART_SIZE;
    private final AmazonS3 s3Client;
    private final String bucketName;
    private final String key;
    private final ObjectMetadata metadata;
    private String uploadId;
    private List<PartETag> partETags;
    private boolean writeCompleted;

    public FileStorageS3OutputStream(AmazonS3 s3Client, String bucketName, String key, ObjectMetadata metadata, long partSize) {
        this.PART_SIZE = partSize;
        this.s3Client = s3Client;
        this.bucketName = bucketName;
        this.key = key;
        this.metadata = metadata;
        this.partETags = new ArrayList<PartETag>();
        this.writeCompleted = false;
    }

    @Override
    public void write(int b) throws IOException {
        throw new UnsupportedOperationException("Not support method");
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        if (this.partETags.size() == 0) {
            if ((long)len < this.PART_SIZE) {
                this.putObject(b, off, len);
                return;
            }
            InitiateMultipartUploadRequest initRequest = new InitiateMultipartUploadRequest(this.bucketName, this.key, this.metadata);
            InitiateMultipartUploadResult initResponse = this.s3Client.initiateMultipartUpload(initRequest);
            this.uploadId = initResponse.getUploadId();
        }
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(b, off, len);){
            UploadPartRequest uploadRequest = new UploadPartRequest().withBucketName(this.bucketName).withKey(this.key).withUploadId(this.uploadId).withPartNumber(this.partETags.size() + 1).withInputStream((InputStream)inputStream).withPartSize((long)len);
            UploadPartResult result = this.s3Client.uploadPart(uploadRequest);
            this.partETags.add(result.getPartETag());
        }
    }

    @Override
    public void flush() throws IOException {
    }

    private void putObject(byte[] b, int off, int len) throws IOException {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(b, off, len);){
            this.metadata.setContentLength((long)len);
            this.s3Client.putObject(new PutObjectRequest(this.bucketName, this.key, (InputStream)inputStream, this.metadata));
        }
    }

    @Override
    public void close() throws IOException {
        if (this.uploadId != null) {
            if (this.partETags.size() > 0 && this.isWriteCompleted()) {
                this.completeMultipartUpload();
                this.uploadId = null;
            } else {
                this.abortMultipartUpload();
                this.uploadId = null;
                throw new IOException("Upload aborted: Incomplete data write (not all content was processed) or setWriteCompleted for copy completion was not invoked");
            }
        }
    }

    private void completeMultipartUpload() {
        CompleteMultipartUploadRequest uploadRequest = new CompleteMultipartUploadRequest(this.bucketName, this.key, this.uploadId, this.partETags);
        this.s3Client.completeMultipartUpload(uploadRequest);
    }

    private void abortMultipartUpload() {
        AbortMultipartUploadRequest uploadRequest = new AbortMultipartUploadRequest(this.bucketName, this.key, this.uploadId);
        this.s3Client.abortMultipartUpload(uploadRequest);
    }

    public boolean isWriteCompleted() {
        return this.writeCompleted;
    }

    public void setWriteCompleted(boolean writeCompleted) {
        this.writeCompleted = writeCompleted;
    }
}

