/*
 * Decompiled with CFR 0.152.
 */
package framework.storage;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import framework.config.S3Config;
import framework.storage.FileStorage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class FileStorageS3
implements FileStorage {
    private static final int BUFFER_SIZE = 0x100000;
    private S3Config config;

    public FileStorageS3(S3Config config) {
        this.config = config;
    }

    protected String getBucket() {
        return this.config.getBucket();
    }

    @Override
    public String[] compressionPathStarts() {
        return this.config.getCompressPathStarts();
    }

    protected AmazonS3 s3() {
        ClientConfiguration config = new ClientConfiguration();
        AwsClientBuilder.EndpointConfiguration endpointConfig = new AwsClientBuilder.EndpointConfiguration(this.config.getEndPoint(), this.config.getRegion());
        BasicAWSCredentials awsCredentials = new BasicAWSCredentials(this.config.getAccessKey(), this.config.getSecretKey());
        AWSStaticCredentialsProvider awsCredentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)awsCredentials);
        AmazonS3 s3 = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3Client.builder().withEndpointConfiguration(endpointConfig)).withClientConfiguration(config)).withCredentials((AWSCredentialsProvider)awsCredentialsProvider)).disableChunkedEncoding()).withPathStyleAccessEnabled(this.config.getPathStyle())).build();
        return s3;
    }

    @Override
    public long save(InputStream inputStream, String filePath, boolean compression) throws IOException {
        if (compression) {
            filePath = filePath + ".gz";
        }
        int maxMemory = this.config.getSaveMemoryMax();
        byte[] buffer = new byte[0x100000];
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(0x100000);){
            Throwable throwable;
            int bytesRead;
            int total = 0;
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                byteArrayOutputStream.write(buffer, 0, bytesRead);
                if ((total += bytesRead) <= maxMemory) continue;
                if (compression) {
                    long l = this.multipartPutCompression(byteArrayOutputStream.toByteArray(), inputStream, filePath);
                    return l;
                }
                long l = this.multipartPut(byteArrayOutputStream.toByteArray(), inputStream, filePath);
                return l;
            }
            byte[] bytes = byteArrayOutputStream.toByteArray();
            if (compression) {
                byteArrayOutputStream.reset();
                throwable = null;
                try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream(byteArrayOutputStream);){
                    gzipOutputStream.write(bytes);
                    gzipOutputStream.finish();
                    bytes = byteArrayOutputStream.toByteArray();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            throwable = null;
            try (ByteArrayInputStream inputStream2 = new ByteArrayInputStream(bytes);){
                ObjectMetadata objectMetadata = new ObjectMetadata();
                objectMetadata.setContentLength((long)bytes.length);
                this.s3().putObject(this.getBucket(), filePath, (InputStream)inputStream2, objectMetadata);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            long l = bytes.length;
            return l;
        }
    }

    @Override
    public InputStream getStream(String filePath, boolean compression) throws IOException {
        S3ObjectInputStream objectContent;
        if (compression) {
            filePath = filePath + ".gz";
        }
        try {
            S3Object object = this.s3().getObject(this.getBucket(), filePath);
            objectContent = object.getObjectContent();
        }
        catch (AmazonS3Exception exception) {
            if (exception.getStatusCode() == 404) {
                throw new FileNotFoundException("File not found (" + exception.getMessage() + ")");
            }
            throw new IOException("File not found", exception);
        }
        if (compression) {
            return new GZIPInputStream((InputStream)objectContent);
        }
        return objectContent;
    }

    @Override
    public void delete(String filePath, boolean compression) throws IOException {
        if (compression) {
            filePath = filePath + ".gz";
        }
        this.s3().deleteObject(this.getBucket(), filePath);
    }

    @Override
    public long length(String filePath, boolean compression) throws IOException {
        if (compression) {
            filePath = filePath + ".gz";
        }
        try {
            ObjectMetadata metadata = this.s3().getObjectMetadata(this.getConfig().getBucket(), filePath);
            return metadata.getContentLength();
        }
        catch (AmazonS3Exception exception) {
            if (exception.getStatusCode() == 404) {
                return -1L;
            }
            throw new IOException("File not found", exception);
        }
    }

    private long multipartPut(byte[] data, InputStream inputStream, String filePath) throws IOException {
        AmazonS3 s3Client = this.s3();
        String bucketName = this.getBucket();
        InitiateMultipartUploadRequest initRequest = new InitiateMultipartUploadRequest(bucketName, filePath);
        InitiateMultipartUploadResult initResponse = s3Client.initiateMultipartUpload(initRequest);
        ArrayList<PartETag> partETags = new ArrayList<PartETag>();
        int partNumber = 1;
        long total = 0L;
        try {
            int partSize = this.config.getPartSize();
            if (partSize < 0x500000) {
                throw new IOException("config sys.s3.partSize must than 5MB");
            }
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(Math.max(partSize, data.length));){
                total += (long)data.length;
                byteArrayOutputStream.write(data);
                byte[] buffer = new byte[partSize];
                boolean loop = true;
                while (loop) {
                    byte[] bytes;
                    while (byteArrayOutputStream.size() < partSize) {
                        int read = inputStream.read(buffer, 0, partSize - byteArrayOutputStream.size());
                        if (read == -1) {
                            loop = false;
                            break;
                        }
                        byteArrayOutputStream.write(buffer, 0, read);
                        total += (long)read;
                    }
                    if ((bytes = byteArrayOutputStream.toByteArray()).length > 0) {
                        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);){
                            UploadPartRequest uploadRequest = new UploadPartRequest().withBucketName(bucketName).withKey(filePath).withUploadId(initResponse.getUploadId()).withPartNumber(partNumber++).withPartSize((long)bytes.length).withInputStream((InputStream)byteArrayInputStream);
                            UploadPartResult uploadResult = s3Client.uploadPart(uploadRequest);
                            partETags.add(uploadResult.getPartETag());
                        }
                    }
                    byteArrayOutputStream.reset();
                }
            }
            CompleteMultipartUploadRequest compRequest = new CompleteMultipartUploadRequest(bucketName, filePath, initResponse.getUploadId(), partETags);
            s3Client.completeMultipartUpload(compRequest);
        }
        catch (Exception exception) {
            s3Client.abortMultipartUpload(new AbortMultipartUploadRequest(bucketName, filePath, initResponse.getUploadId()));
            throw exception;
        }
        return total;
    }

    private long multipartPutCompression(byte[] data, InputStream inputStream, String filePath) throws IOException {
        AmazonS3 s3Client = this.s3();
        String bucketName = this.getBucket();
        InitiateMultipartUploadRequest initRequest = new InitiateMultipartUploadRequest(bucketName, filePath);
        InitiateMultipartUploadResult initResponse = s3Client.initiateMultipartUpload(initRequest);
        ArrayList<PartETag> partETags = new ArrayList<PartETag>();
        int partNumber = 1;
        long total = 0L;
        try (ByteArrayOutputStream compressionOutputStream = new ByteArrayOutputStream(Math.max(0x100000, data.length));
             GZIPOutputStream gzipOutputStream = new GZIPOutputStream(compressionOutputStream);){
            total += (long)data.length;
            gzipOutputStream.write(data);
            int partSize = this.config.getPartSize();
            if (partSize < 0x500000) {
                throw new IOException("config sys.s3.partSize must than 5MB");
            }
            byte[] buffer = new byte[partSize];
            boolean loop = true;
            while (loop) {
                byte[] bytes;
                while (compressionOutputStream.size() < partSize) {
                    int read = inputStream.read(buffer);
                    if (read == -1) {
                        loop = false;
                        gzipOutputStream.finish();
                        break;
                    }
                    gzipOutputStream.write(buffer, 0, read);
                    total += (long)read;
                }
                if ((bytes = compressionOutputStream.toByteArray()).length > 0) {
                    try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);){
                        UploadPartRequest uploadRequest = new UploadPartRequest().withBucketName(bucketName).withKey(filePath).withUploadId(initResponse.getUploadId()).withPartNumber(partNumber++).withPartSize((long)bytes.length).withInputStream((InputStream)byteArrayInputStream);
                        UploadPartResult uploadResult = s3Client.uploadPart(uploadRequest);
                        partETags.add(uploadResult.getPartETag());
                    }
                }
                compressionOutputStream.reset();
            }
            CompleteMultipartUploadRequest compRequest = new CompleteMultipartUploadRequest(bucketName, filePath, initResponse.getUploadId(), partETags);
            s3Client.completeMultipartUpload(compRequest);
        }
        catch (Exception exception) {
            s3Client.abortMultipartUpload(new AbortMultipartUploadRequest(bucketName, filePath, initResponse.getUploadId()));
            throw exception;
        }
        return total;
    }

    public S3Config getConfig() {
        return this.config;
    }
}

