/*
 * Decompiled with CFR 0.152.
 */
package framework.storage;

import framework.config.FileConfig;
import framework.storage.FileStorage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;

public class FileStorageLocal
implements FileStorage {
    private static final int BUFFER_SIZE = 0x100000;
    private FileConfig config;

    public FileStorageLocal(FileConfig config) {
        this.config = config;
    }

    @Override
    public String[] compressionPathStarts() {
        return this.config.getCompressPathStarts();
    }

    @Override
    public long save(InputStream inputStream, String filePath, boolean compression) throws IOException {
        long rows;
        File file;
        filePath = this.buildFilePath(filePath);
        if (compression) {
            filePath = filePath + ".gz";
        }
        if (!(file = new File(filePath)).getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            if (compression) {
                try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream(outputStream);){
                    long rows2 = IOUtils.copy((InputStream)inputStream, (OutputStream)gzipOutputStream, (int)0x100000);
                    gzipOutputStream.finish();
                    long l = rows2;
                    return l;
                }
            }
            rows = IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream, (int)0x100000);
        }
        outputStream.flush();
        long l = rows;
        return l;
    }

    @Override
    public InputStream getStream(String filePath, boolean compression) throws IOException {
        filePath = this.buildFilePath(filePath);
        if (compression) {
            filePath = filePath + ".gz";
            return new GZIPInputStream(new FileInputStream(filePath));
        }
        return new FileInputStream(filePath);
    }

    @Override
    public void delete(String filePath, boolean compression) throws IOException {
        filePath = this.buildFilePath(filePath);
        if (compression) {
            filePath = filePath + ".gz";
        }
        new File(filePath).delete();
    }

    @Override
    public long length(String filePath, boolean compression) throws IOException {
        File file;
        filePath = this.buildFilePath(filePath);
        if (compression) {
            filePath = filePath + ".gz";
        }
        if (!(file = new File(filePath)).exists()) {
            return -1L;
        }
        return file.length();
    }

    private String buildFilePath(String filePath) {
        if (filePath.charAt(0) == '/' || filePath.charAt(0) == '\\') {
            filePath = filePath.substring(1);
        }
        return this.config.getStoragePath() + File.separator + filePath;
    }

    public FileConfig getConfig() {
        return this.config;
    }
}

