/*
 * Decompiled with CFR 0.152.
 */
package framework.storage;

import framework.config.FileStorageHttpConfig;
import framework.storage.FileStorage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.lang3.StringUtils;

public class FileStorageHttp
implements FileStorage {
    private static final int BUFFER_SIZE = 0x100000;
    private FileStorageHttpConfig config;

    public FileStorageHttp(FileStorageHttpConfig config) {
        this.config = config;
    }

    protected void setupTimeout(HttpURLConnection connection) {
        if (this.getConfig().getConnectTimeout() != null) {
            connection.setConnectTimeout(this.getConfig().getConnectTimeout());
        }
        if (this.getConfig().getReadTimeout() != null) {
            connection.setReadTimeout(this.getConfig().getReadTimeout());
        }
    }

    protected void setupAuth(HttpURLConnection connection) {
        if (StringUtils.isNotBlank((CharSequence)this.config.getAuthorization())) {
            connection.setRequestProperty("Authorization", this.config.getAuthorization());
        }
    }

    protected void setupConnection(HttpURLConnection connection) {
    }

    @Override
    public long save(InputStream inputStream, String filePath, boolean compression) throws IOException {
        if (compression) {
            filePath = filePath + ".gz";
        }
        URI uri = this.getConfig().uri(filePath);
        HttpURLConnection connection = (HttpURLConnection)uri.toURL().openConnection();
        connection.setRequestMethod("PUT");
        connection.setDoOutput(true);
        this.setupTimeout(connection);
        this.setupAuth(connection);
        this.setupConnection(connection);
        long len = 0L;
        try (OutputStream os = compression ? new GZIPOutputStream(connection.getOutputStream()) : connection.getOutputStream();){
            int bytesRead;
            byte[] buffer = new byte[0x100000];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                os.write(buffer, 0, bytesRead);
                len += (long)bytesRead;
            }
        }
        int responseCode = connection.getResponseCode();
        if (responseCode == 200 || responseCode == 201) {
            return len;
        }
        throw new IOException("PUT request failed with response code: " + responseCode);
    }

    @Override
    public InputStream getStream(String filePath, boolean compression) throws IOException {
        if (compression) {
            filePath = filePath + ".gz";
        }
        URI uri = this.config.uri(filePath);
        HttpURLConnection connection = (HttpURLConnection)uri.toURL().openConnection();
        connection.setRequestMethod("GET");
        this.setupTimeout(connection);
        this.setupAuth(connection);
        this.setupConnection(connection);
        int responseCode = connection.getResponseCode();
        if (responseCode != 200) {
            throw new IOException("GET request failed with response code: " + responseCode);
        }
        InputStream inputStream = connection.getInputStream();
        if (compression) {
            return new GZIPInputStream(inputStream);
        }
        return inputStream;
    }

    @Override
    public void delete(String filePath, boolean compression) throws IOException {
        if (compression) {
            filePath = filePath + ".gz";
        }
        URI uri = this.config.uri(filePath);
        HttpURLConnection connection = (HttpURLConnection)uri.toURL().openConnection();
        connection.setRequestMethod("DELETE");
        this.setupTimeout(connection);
        this.setupAuth(connection);
        this.setupConnection(connection);
        int responseCode = connection.getResponseCode();
        if (responseCode != 200) {
            throw new IOException("DELETE request failed with response code: " + responseCode);
        }
    }

    @Override
    public long length(String filePath, boolean compression) throws IOException {
        if (compression) {
            filePath = filePath + ".gz";
        }
        URI uri = this.config.uri(filePath);
        HttpURLConnection connection = (HttpURLConnection)uri.toURL().openConnection();
        connection.setRequestMethod("HEAD");
        this.setupTimeout(connection);
        this.setupAuth(connection);
        this.setupConnection(connection);
        int responseCode = connection.getResponseCode();
        if (responseCode == 404) {
            return -1L;
        }
        if (responseCode != 200) {
            throw new IOException("LENGTH request failed with response code: " + responseCode);
        }
        return connection.getContentLengthLong();
    }

    public FileStorageHttpConfig getConfig() {
        return this.config;
    }
}

