/*
 * Decompiled with CFR 0.152.
 */
package framework.storage;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;

public interface FileStorage {
    default public boolean enable() {
        return true;
    }

    default public boolean isCompression(String filePath) {
        String[] starts = this.compressionPathStarts();
        if (starts == null) {
            return false;
        }
        if (starts.length == 0) {
            return false;
        }
        for (String s : starts) {
            if (!filePath.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    default public String[] compressionPathStarts() {
        return null;
    }

    default public long save(String content, String filePath) throws IOException {
        byte[] contentBytes = content.getBytes();
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(contentBytes, 0, contentBytes.length);){
            long l = this.save(byteArrayInputStream, filePath);
            return l;
        }
    }

    default public long save(InputStream inputStream, String filePath) throws IOException {
        boolean compression = this.isCompression(filePath);
        return this.save(inputStream, filePath, compression);
    }

    public long save(InputStream var1, String var2, boolean var3) throws IOException;

    default public long save(byte[] data, String filePath) throws IOException {
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(data, 0, data.length);){
            long l = this.save(byteArrayInputStream, filePath);
            return l;
        }
    }

    default public String getString(String filePath) throws IOException {
        String str = null;
        try (InputStream stream = this.getStream(filePath);){
            str = IOUtils.toString((InputStream)stream, (String)"UTF-8");
        }
        return str;
    }

    default public byte[] getData(String filePath) throws IOException {
        byte[] content;
        try (InputStream stream = this.getStream(filePath);){
            content = IOUtils.toByteArray((InputStream)stream);
        }
        return content;
    }

    default public InputStream getStream(String filePath) throws IOException {
        boolean compression = this.isCompression(filePath);
        return this.getStream(filePath, compression);
    }

    public InputStream getStream(String var1, boolean var2) throws IOException;

    default public void delete(String filePath) throws IOException {
        boolean compression = this.isCompression(filePath);
        this.delete(filePath, compression);
    }

    public void delete(String var1, boolean var2) throws IOException;

    default public boolean tryDelete(String filePath, boolean compression) {
        boolean deleted = true;
        try {
            this.delete(filePath, compression);
        }
        catch (Exception e) {
            deleted = false;
        }
        return deleted;
    }

    default public boolean tryDelete(String filePath) {
        boolean compression = this.isCompression(filePath);
        return this.tryDelete(filePath, compression);
    }

    default public long length(String filePath) throws IOException {
        boolean compression = this.isCompression(filePath);
        return this.length(filePath, compression);
    }

    public long length(String var1, boolean var2) throws IOException;
}

