/*
 * Decompiled with CFR 0.152.
 */
package framework.storage;

import framework.utils.Base32Util;
import framework.utils.Base58Util;
import framework.utils.IdUtil;
import framework.utils.UUIDUtil;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

public class FilePathBuilder {
    private Long identity;
    private UUID uuid;
    private ZonedDateTime time;
    private String ext;
    private final List<String> list = new ArrayList<String>();
    private ZoneId zoneId = ZoneOffset.UTC;

    public String build() {
        return "/" + String.join((CharSequence)"/", this.list) + (StringUtils.isBlank((CharSequence)this.ext) ? "" : this.ext);
    }

    protected UUID getUUID() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID();
        }
        return this.uuid;
    }

    protected Long getIdentity() {
        if (this.identity == null) {
            this.identity = IdUtil.newId();
        }
        return this.identity;
    }

    protected Long getIdentity(Long id) {
        this.identity = id;
        return this.identity;
    }

    protected ZonedDateTime getTime() {
        if (this.time == null) {
            this.time = ZonedDateTime.now(this.getZoneId());
        }
        return this.time;
    }

    public FilePathBuilder append(String fragment) {
        this.list.add(fragment);
        return this;
    }

    public FilePathBuilder uuid() {
        this.list.add(this.getUUID().toString().replace("-", ""));
        return this;
    }

    public FilePathBuilder base32() {
        this.list.add(Base32Util.encode(this.getIdentity()));
        return this;
    }

    public FilePathBuilder base58() {
        this.list.add(Base58Util.encodeBytes(UUIDUtil.toBytes(this.getUUID())));
        return this;
    }

    public FilePathBuilder id() {
        this.list.add("" + this.getIdentity());
        return this;
    }

    public FilePathBuilder id(Long id) {
        this.list.add("" + this.getIdentity());
        return this;
    }

    public FilePathBuilder partId() {
        long c = this.getIdentity();
        long a = c % 99L;
        long b = c % 9999L;
        this.list.add("" + a);
        this.list.add("" + b);
        return this;
    }

    public FilePathBuilder partTime() {
        long c = this.getTime().toEpochSecond();
        long a = c % 99L;
        long b = c % 9999L;
        this.list.add("" + a);
        this.list.add("" + b);
        return this;
    }

    public FilePathBuilder year() {
        this.list.add("" + this.getTime().getYear());
        return this;
    }

    public FilePathBuilder month() {
        int v = this.getTime().getMonthValue();
        if (v < 10) {
            this.list.add("0" + v);
        } else {
            this.list.add("" + v);
        }
        return this;
    }

    public FilePathBuilder day() {
        int v = this.getTime().getDayOfMonth();
        if (v < 10) {
            this.list.add("0" + v);
        } else {
            this.list.add("" + v);
        }
        return this;
    }

    public FilePathBuilder extension(String ext) {
        this.ext = StringUtils.isNotBlank((CharSequence)ext) ? "." + ext : "";
        return this;
    }

    public static String buildYearMonthIDFilePath(String ext) {
        return new FilePathBuilder().year().month().id().extension(ext).build();
    }

    public static String buildYearMonthUUIDFilePath(String ext) {
        return new FilePathBuilder().year().month().uuid().extension(ext).build();
    }

    public static String buildPartUUIDFilePath(String ext) {
        return new FilePathBuilder().partTime().uuid().extension(ext).build();
    }

    public static String buildPartIDFilePath(String ext) {
        return new FilePathBuilder().partId().id().extension(ext).build();
    }

    public static String buildPartBase32FilePath(String ext) {
        return new FilePathBuilder().partId().base32().extension(ext).build();
    }

    public static String buildPartBase58FilePath(String ext) {
        return new FilePathBuilder().partTime().base58().extension(ext).build();
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(ZoneId zoneId) {
        this.zoneId = zoneId;
    }
}

