/*
 * Decompiled with CFR 0.152.
 */
package framework.snowflake;

import framework.snowflake.NextId;
import framework.snowflake.Snowflake16;

public class SnowflakeWorker
implements NextId {
    private long workerId;
    private long datacenterId;
    private long sequence;
    private long twepoch = 1288834974657L;
    private long workerIdBits = 5L;
    private long datacenterIdBits = 5L;
    private long maxWorkerId = 0xFFFFFFFFFFFFFFFFL ^ -1L << (int)this.workerIdBits;
    private long maxDatacenterId = 0xFFFFFFFFFFFFFFFFL ^ -1L << (int)this.datacenterIdBits;
    private long sequenceBits = 12L;
    private long sequenceMask = 0xFFFFFFFFFFFFFFFFL ^ -1L << (int)this.sequenceBits;
    private long workerIdShift = this.sequenceBits;
    private long datacenterIdShift = this.sequenceBits + this.workerIdBits;
    private long timestampLeftShift = this.sequenceBits + this.workerIdBits + this.datacenterIdBits;
    private long lastTimestamp = -1L;

    public SnowflakeWorker(long workerId, long datacenterId) {
        long sequence = 0L;
        this.init(workerId, datacenterId, sequence);
    }

    public SnowflakeWorker(long workerId, long datacenterId, long sequence) {
        this.init(workerId, datacenterId, sequence);
    }

    private void init(long workerId, long datacenterId, long sequence) {
        if (workerId > this.maxWorkerId || workerId < 0L) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", this.maxWorkerId));
        }
        if (datacenterId > this.maxDatacenterId || datacenterId < 0L) {
            throw new IllegalArgumentException(String.format("datacenter Id can't be greater than %d or less than 0", this.maxDatacenterId));
        }
        System.out.printf("worker starting. time length %d, timestamp left shift %d, datacenter id bits %d, worker id bits %d, sequence bits %d, workerid %d, datacenterId %d", 64L - (this.timestampLeftShift + this.datacenterIdBits + this.workerIdBits + this.sequenceBits), this.timestampLeftShift, this.datacenterIdBits, this.workerIdBits, this.sequenceBits, workerId, datacenterId);
        System.out.println("");
        this.workerId = workerId;
        this.datacenterId = datacenterId;
        this.sequence = sequence;
    }

    @Override
    public synchronized long nextId() {
        long timestamp = this.timeGen();
        if (timestamp < this.lastTimestamp) {
            System.err.printf("clock is moving backwards.  Rejecting requests until %d.", this.lastTimestamp);
            throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & this.sequenceMask;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - this.twepoch << (int)this.timestampLeftShift | this.datacenterId << (int)this.datacenterIdShift | this.workerId << (int)this.workerIdShift | this.sequence;
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    private long timeGen() {
        return System.currentTimeMillis();
    }

    public static void main(String[] args) {
        SnowflakeWorker worker = new SnowflakeWorker(2L, 2L, 0L);
        System.out.println(worker.nextId());
        Snowflake16 worker1 = new Snowflake16(2L, 2L, 0L);
        System.out.println(worker1.nextId());
    }
}

