/*
 * Decompiled with CFR 0.152.
 */
package framework.snowflake;

import framework.runtime.SystemContext;
import framework.snowflake.NextId;
import framework.snowflake.Snowflake16;
import framework.snowflake.SnowflakeConfig;
import framework.snowflake.SnowflakeWorker;
import framework.utils.ConvertUtil;
import framework.utils.EnvUtil;

public class Snowflake {
    private static NextId worker;

    public static long nextId() {
        long id = worker.nextId();
        return id;
    }

    static {
        Long workerId = 0L;
        Long datacenterId = 0L;
        Long length = 0L;
        try {
            SnowflakeConfig snowflakeConfig = SystemContext.getBean(SnowflakeConfig.class);
            workerId = snowflakeConfig.getWorker();
            datacenterId = snowflakeConfig.getCenter();
            length = snowflakeConfig.getLength();
        }
        catch (NullPointerException exception) {
            String w = EnvUtil.env("SNOWFLAKE_WORKER");
            String d = EnvUtil.env("SNOWFLAKE_CENTER");
            String l = EnvUtil.env("SNOWFLAKE_LENGTH");
            workerId = ConvertUtil.toLong(w);
            datacenterId = ConvertUtil.toLong(d);
            length = ConvertUtil.toLong(l);
        }
        worker = length == 19L ? new SnowflakeWorker(workerId, datacenterId) : new Snowflake16(workerId, datacenterId);
    }
}

