/*
 * Decompiled with CFR 0.152.
 */
package framework.service;

import framework.service.FlagAdmin;
import org.springframework.cache.Cache;

public class FlagAdminDefault
implements FlagAdmin {
    public static final String DEFAULT_VALUE = "1";
    private final Cache cache;
    private final String groupName;
    private final String defaultName = "DEFAULT";

    public FlagAdminDefault(Cache cache, String groupName) {
        this.cache = cache;
        this.groupName = groupName;
    }

    protected String buildKey(String name) {
        return (this.getGroupName() + name).toUpperCase();
    }

    @Override
    public void setFlag() {
        this.setFlag(this.getDefaultName(), DEFAULT_VALUE);
    }

    @Override
    public void setFlag(String name) {
        this.setFlag(name, DEFAULT_VALUE);
    }

    @Override
    public void setFlag(String name, String value) {
        String key = this.buildKey(name);
        this.getCache().put((Object)key, (Object)value);
    }

    @Override
    public void remove() {
        this.remove(this.getDefaultName());
    }

    @Override
    public void remove(String name) {
        String key = this.buildKey(name);
        this.getCache().evict((Object)key);
    }

    @Override
    public boolean hasFlag() {
        return this.hasFlag(this.getDefaultName(), DEFAULT_VALUE);
    }

    @Override
    public boolean hasFlag(String value) {
        return this.hasFlag(this.getDefaultName(), value);
    }

    @Override
    public boolean hasFlag(String name, String value) {
        if (value == null) {
            return false;
        }
        String key = this.buildKey(name);
        Cache.ValueWrapper v = this.getCache().get((Object)key);
        if (v == null) {
            return false;
        }
        Object o = v.get();
        if (o == null) {
            return false;
        }
        return value.equals(o);
    }

    public Cache getCache() {
        return this.cache;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getDefaultName() {
        return this.defaultName;
    }
}

