/*
 * Decompiled with CFR 0.152.
 */
package framework.security.token;

import java.util.Date;
import java.util.Random;

public class AuthTokenInfo {
    private long id;
    private Date expireTime;
    private int duration;
    private long sid;

    public AuthTokenInfo(long id, int duration) {
        this.id = id;
        this.duration = duration;
        this.expireTime = new Date(System.currentTimeMillis() + (long)duration * 1000L);
        this.sid = Math.abs(new Random().nextLong()) % 0x1FFFFFFFFFFFFFL;
    }

    public AuthTokenInfo(long id, Date expireTime, int duration, long sid) {
        this.id = id;
        this.expireTime = expireTime;
        this.duration = duration;
        this.sid = sid;
    }

    public boolean isExpired() {
        if (this.expireTime == null) {
            return false;
        }
        boolean expired = new Date().getTime() > this.expireTime.getTime();
        return expired;
    }

    public long getId() {
        return this.id;
    }

    public Date getExpireTime() {
        return this.expireTime;
    }

    public int getDuration() {
        return this.duration;
    }

    public long getSid() {
        return this.sid;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setExpireTime(Date expireTime) {
        this.expireTime = expireTime;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public void setSid(long sid) {
        this.sid = sid;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthTokenInfo)) {
            return false;
        }
        AuthTokenInfo other = (AuthTokenInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getDuration() != other.getDuration()) {
            return false;
        }
        if (this.getSid() != other.getSid()) {
            return false;
        }
        Date this$expireTime = this.getExpireTime();
        Date other$expireTime = other.getExpireTime();
        return !(this$expireTime == null ? other$expireTime != null : !((Object)this$expireTime).equals(other$expireTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AuthTokenInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        result = result * 59 + this.getDuration();
        long $sid = this.getSid();
        result = result * 59 + (int)($sid >>> 32 ^ $sid);
        Date $expireTime = this.getExpireTime();
        result = result * 59 + ($expireTime == null ? 43 : ((Object)$expireTime).hashCode());
        return result;
    }

    public String toString() {
        return "AuthTokenInfo(id=" + this.getId() + ", expireTime=" + this.getExpireTime() + ", duration=" + this.getDuration() + ", sid=" + this.getSid() + ")";
    }

    public AuthTokenInfo() {
    }
}

