/*
 * Decompiled with CFR 0.152.
 */
package framework.security.token;

import framework.config.AESCryptoConfig;
import framework.crypto.AESCrypto;
import framework.crypto.AESCryptoPlus;
import framework.security.token.AuthTokenInfo;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class AuthTokenBuilder {
    private static final Logger log = LoggerFactory.getLogger(AuthTokenBuilder.class);
    private final AESCrypto crypto;

    public AuthTokenBuilder(String secret, int currentIndex) {
        if (!StringUtils.hasText((String)secret) || ",".equals(secret)) {
            throw new IllegalArgumentException("secret invalid");
        }
        AESCryptoConfig config = new AESCryptoConfig();
        config.setSecretIndex(currentIndex);
        config.setSecretKey(secret);
        this.crypto = this.createCrypto(config);
    }

    protected AESCrypto createCrypto(AESCryptoConfig config) {
        return new AESCryptoPlus(config);
    }

    private String encode(long userId, Date time, int duration, long sid) {
        if (time == null) {
            throw new IllegalArgumentException("no set time");
        }
        byte[] b1 = this.encodeV3(userId, time, duration, sid);
        String s = this.getCrypto().encodeUrlBase64(b1);
        return s;
    }

    public String encode(AuthTokenInfo authTokenInfo) {
        long l1 = authTokenInfo.getId();
        Date time = authTokenInfo.getExpireTime();
        int duration = authTokenInfo.getDuration();
        long sid = authTokenInfo.getSid();
        String s = this.encode(l1, time, duration, sid);
        return s;
    }

    public AuthTokenInfo decode(String encodeContent) {
        byte[] b1 = this.getCrypto().decodeUrlBase64(encodeContent);
        if (b1 == null) {
            return null;
        }
        if (b1.length == 37) {
            return this.decodeV3(b1);
        }
        if (b1.length == 33) {
            return this.decodeV2(b1);
        }
        if (b1.length == 31) {
            return this.decodeV0(b1);
        }
        if (b1.length == 39) {
            return this.decodeV1(b1);
        }
        return null;
    }

    private byte[] encodeV0(Long userId, Date time) {
        byte[] input = new byte[31];
        new Random().nextBytes(input);
        return ByteBuffer.wrap(input).putLong(9, userId).putLong(17, time.getTime()).array();
    }

    private AuthTokenInfo decodeV0(byte[] b1) {
        ByteBuffer buffer = ByteBuffer.wrap(b1);
        Long l1 = buffer.getLong(9);
        Long l2 = buffer.getLong(17);
        AuthTokenInfo authTokenInfo = new AuthTokenInfo();
        authTokenInfo.setId(l1);
        authTokenInfo.setExpireTime(new Date(l2));
        return authTokenInfo;
    }

    private byte[] encodeV1(Long userId, Date expireTime) {
        byte[] input = new byte[39];
        new Random().nextBytes(input);
        input[1] = 1;
        long now = System.currentTimeMillis();
        long len = (expireTime.getTime() - now) / 1000L;
        if (len > 31536000L) {
            throw new RuntimeException("expire time not than 365 days");
        }
        return ByteBuffer.wrap(input).putLong(9, userId).putLong(17, expireTime.getTime()).putLong(27, now).array();
    }

    private byte[] encodeV2(Long userId, Date time, Integer duration) {
        byte[] input = new byte[33];
        new Random().nextBytes(input);
        int pos = Math.abs(input[0]) % 9;
        return ByteBuffer.wrap(input).putLong(pos, userId).putLong(pos + 8 + 2, time.getTime()).putInt(pos + 8 + 2 + 8 + 1, duration).array();
    }

    private AuthTokenInfo decodeV2(byte[] b1) {
        ByteBuffer buffer = ByteBuffer.wrap(b1);
        int pos = Math.abs(b1[0]) % 9;
        Long l1 = buffer.getLong(pos);
        Long l2 = buffer.getLong(pos + 8 + 2);
        Integer l3 = buffer.getInt(pos + 8 + 2 + 8 + 1);
        AuthTokenInfo authTokenInfo = new AuthTokenInfo();
        authTokenInfo.setId(l1);
        authTokenInfo.setExpireTime(new Date(l2));
        authTokenInfo.setDuration(l3);
        return authTokenInfo;
    }

    private AuthTokenInfo decodeV1(byte[] b1) {
        ByteBuffer buffer = ByteBuffer.wrap(b1);
        Long id = buffer.getLong(9);
        Long expireTime = buffer.getLong(17);
        AuthTokenInfo authTokenInfo = new AuthTokenInfo();
        authTokenInfo.setId(id);
        authTokenInfo.setExpireTime(new Date(expireTime));
        return authTokenInfo;
    }

    private byte[] encodeV3(long userId, Date time, int duration, long sid) {
        byte[] input = new byte[37];
        new Random().nextBytes(input);
        int pos = Math.abs(input[0]) % 9;
        return ByteBuffer.wrap(input).putLong(pos, userId).putLong(pos + 8, time.getTime()).putLong(pos + 8 + 8, sid).putInt(pos + 8 + 8 + 8, duration).array();
    }

    private AuthTokenInfo decodeV3(byte[] b1) {
        ByteBuffer buffer = ByteBuffer.wrap(b1);
        int pos = Math.abs(b1[0]) % 9;
        long u = buffer.getLong(pos);
        long t = buffer.getLong(pos + 8);
        long s = buffer.getLong(pos + 8 + 8);
        int d = buffer.getInt(pos + 8 + 8 + 8);
        AuthTokenInfo authTokenInfo = new AuthTokenInfo();
        authTokenInfo.setId(u);
        authTokenInfo.setExpireTime(new Date(t));
        authTokenInfo.setDuration(d);
        authTokenInfo.setSid(s);
        return authTokenInfo;
    }

    public AESCrypto getCrypto() {
        return this.crypto;
    }
}

