/*
 * Decompiled with CFR 0.152.
 */
package framework.security.password;

import framework.security.password.PasswordMD5Mode;
import framework.security.password.PasswordMode;
import framework.security.password.PasswordService;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class PasswordServiceDefault
implements PasswordService {
    private final Map<String, PasswordMode> encodeMap = new HashMap<String, PasswordMode>();
    private String defaultMode;

    public PasswordServiceDefault() {
        PasswordMD5Mode mode = new PasswordMD5Mode();
        this.addMode(mode);
        this.defaultMode = mode.getName();
    }

    public void setDefaultMode(String mode) {
        if (!this.encodeMap.containsKey(mode)) {
            throw new RuntimeException("Not set password mode: " + mode);
        }
        this.defaultMode = mode;
    }

    @Override
    public Collection<PasswordMode> modes() {
        return this.encodeMap.values();
    }

    @Override
    public String encode(String password, String salt) {
        String mode = this.defaultMode;
        String en = this.getMode(mode).encode(password, salt);
        return mode + "," + en;
    }

    @Override
    public String encode(String mode, String password, String salt) {
        String en = this.getMode(mode).encode(password, salt);
        return mode + "," + en;
    }

    @Override
    public boolean matched(String password, String salt, String encodePassword) {
        String[] items = encodePassword.split(",");
        if (items.length != 2) {
            return false;
        }
        String mode = items[0];
        encodePassword = items[1];
        boolean matched = this.getMode(mode).matched(password, salt, encodePassword);
        return matched;
    }

    @Override
    public PasswordMode getMode(String name) {
        PasswordMode passwordMode = this.encodeMap.get(name);
        if (passwordMode == null) {
            throw new RuntimeException("Not support PasswordMode: " + name);
        }
        return passwordMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMode(PasswordMode mode) {
        Map<String, PasswordMode> map = this.encodeMap;
        synchronized (map) {
            this.encodeMap.put(mode.getName(), mode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delMode(PasswordMode mode) {
        Map<String, PasswordMode> map = this.encodeMap;
        synchronized (map) {
            this.encodeMap.remove(mode.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delMode(String name) {
        Map<String, PasswordMode> map = this.encodeMap;
        synchronized (map) {
            this.encodeMap.remove(name);
        }
    }

    public Map<String, PasswordMode> getEncodeMap() {
        return this.encodeMap;
    }

    public String getDefaultMode() {
        return this.defaultMode;
    }
}

