/*
 * Decompiled with CFR 0.152.
 */
package framework.security;

import framework.exceptions.BusinessException;
import java.util.HashMap;
import java.util.Map;

public class AuthException
extends BusinessException {
    public static final int FAILED = 0;
    public static final int REQUEST_INVALID = 1;
    public static final int LOGIN_LIMITED = 2;
    public static final int ACCOUNT_NOT_EXISTS = 100;
    public static final int ACCOUNT_DISABLED = 101;
    public static final int ACCOUNT_EXPIRED = 102;
    public static final int PASSWORD_NO_SET = 200;
    public static final int PASSWORD_EXPIRED = 201;
    public static final int PASSWORD_NO_MATCH = 202;
    public static final int PASSWORD_NO_INPUT = 203;
    public static final int PASSWORD_INVALID = 204;
    public static final int APPROVAL_REJECTED = 300;
    public static final int APPROVAL_PENDING = 301;
    public static final int CAPTCHA_ERROR = 400;
    private static final Map<Integer, String> resultMap = new HashMap<Integer, String>();
    private static final Map<Integer, String> noLogResultMap = new HashMap<Integer, String>();
    private int authResult;

    public static boolean compare(AuthException authException, int autoResult) {
        return authException.getAuthResult() == autoResult;
    }

    public static boolean isExceptionValue(int value) {
        return resultMap.containsKey(value);
    }

    public AuthException(int authResult, String msg) {
        super(msg);
        this.authResult = authResult;
    }

    public boolean isNoLog() {
        return noLogResultMap.containsKey(this.getAuthResult());
    }

    @Override
    public int getCode() {
        return super.getCode();
    }

    public static Map<Integer, String> getResultMap() {
        return resultMap;
    }

    public static Map<Integer, String> getNoLogResultMap() {
        return noLogResultMap;
    }

    public int getAuthResult() {
        return this.authResult;
    }

    public void setAuthResult(int authResult) {
        this.authResult = authResult;
    }

    static {
        resultMap.put(0, "FAILED");
        resultMap.put(1, "REQUEST_INVALID");
        resultMap.put(2, "LOGIN_LIMITED");
        resultMap.put(100, "ACCOUNT_NOT_EXISTS");
        resultMap.put(101, "ACCOUNT_DISABLED");
        resultMap.put(102, "ACCOUNT_EXPIRED");
        resultMap.put(200, "PASSWORD_NO_SET");
        resultMap.put(201, "PASSWORD_EXPIRED");
        resultMap.put(202, "PASSWORD_NO_MATCH");
        resultMap.put(203, "PASSWORD_NO_INPUT");
        resultMap.put(204, "PASSWORD_INVALID");
        resultMap.put(300, "APPROVAL_REJECTED");
        resultMap.put(301, "APPROVAL_PENDING");
        resultMap.put(400, "CAPTCHA_ERROR");
        noLogResultMap.put(101, "ACCOUNT_DISABLED");
        noLogResultMap.put(102, "ACCOUNT_EXPIRED");
    }
}

