/*
 * Decompiled with CFR 0.152.
 */
package framework.runtime;

import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.NoSuchMessageException;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;

@Component
public class SystemContext
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(SystemContext.class);
    private static ApplicationContext applicationContext;
    private static Boolean isInitialized;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        SystemContext.applicationContext = applicationContext;
        this.printMessage(applicationContext);
        isInitialized = true;
    }

    protected void printMessage(ApplicationContext applicationContext) {
        log.info("Default locale: " + Locale.getDefault());
        log.info("Default message: " + applicationContext.getMessage("language", null, "No set", Locale.getDefault()));
    }

    public static ApplicationContext getContext() {
        return applicationContext;
    }

    public static Object getBean(String name) {
        return applicationContext.getBean(name);
    }

    public static <T> T getBean(Class<T> clazz) {
        return (T)applicationContext.getBean(clazz);
    }

    public static <T> Collection<T> getBeans(Class<T> clazz) {
        Map beansOfType = applicationContext.getBeansOfType(clazz);
        return beansOfType.values();
    }

    public static <T> Map<String, T> getBeansMap(Class<T> clazz) {
        return applicationContext.getBeansOfType(clazz);
    }

    public static void registerBean(String beanName, Class<?> clazz) {
        AutowireCapableBeanFactory beanFactory = applicationContext.getAutowireCapableBeanFactory();
        Object bean = beanFactory.createBean(clazz);
        beanFactory.initializeBean(bean, beanName);
    }

    public static void registerBean(Class<?> clazz) {
        applicationContext.getAutowireCapableBeanFactory().createBean(clazz);
    }

    public static <T> T getBean(String name, Class<T> clazz) {
        return (T)applicationContext.getBean(name, clazz);
    }

    public static String getMessage(String code, @Nullable Object[] args, @Nullable String defaultMessage, Locale locale) {
        String message = applicationContext.getMessage(code, args, defaultMessage, locale);
        return message;
    }

    public static String getMessage(String code, @Nullable Object[] args, Locale locale) throws NoSuchMessageException {
        String message = applicationContext.getMessage(code, args, locale);
        return message;
    }

    public static String getMessage(String code, Object ... args) throws NoSuchMessageException {
        String message = applicationContext.getMessage(code, args, Locale.getDefault());
        return message;
    }

    public static String getMessageDefault(String code, String defaultMessage, Object ... args) throws NoSuchMessageException {
        String message = applicationContext.getMessage(code, args, defaultMessage, Locale.getDefault());
        return message;
    }

    public static Boolean getIsInitialized() {
        return isInitialized;
    }

    static {
        isInitialized = false;
    }
}

