/*
 * Decompiled with CFR 0.152.
 */
package framework.runtime;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.springframework.util.StringUtils;

public class JsonDateSerializer
extends JsonSerializer<Date> {
    private final String dateFormat;
    private final String timeZone;

    public JsonDateSerializer(String dateFormat, String timeZone) {
        this.dateFormat = dateFormat;
        this.timeZone = timeZone;
    }

    public void serialize(Date date, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (date == null) {
            jsonGenerator.writeString("");
            return;
        }
        SimpleDateFormat df = new SimpleDateFormat(this.dateFormat);
        if (StringUtils.hasText((String)this.timeZone)) {
            df.setTimeZone(TimeZone.getTimeZone(this.timeZone));
        }
        jsonGenerator.writeString(df.format(date));
    }
}

