/*
 * Decompiled with CFR 0.152.
 */
package framework.runtime;

import framework.utils.CharsetUtil;
import framework.utils.JsonUtil;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.View;

public class JsonDataView
implements View {
    private static final Logger log = LoggerFactory.getLogger(JsonDataView.class);
    private Object data;

    public JsonDataView() {
    }

    public JsonDataView(Object data) {
        this.data = data;
    }

    public String getContentType() {
        return "application/json";
    }

    public void render(Map<String, ?> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String json = this.buildJson(this.data);
        response.setContentType(this.getContentType());
        response.setCharacterEncoding(CharsetUtil.getSystemCharset());
        try (PrintWriter writer = response.getWriter();){
            writer.write(json);
            writer.flush();
        }
    }

    protected String buildJson(Object data) {
        if (data == null) {
            return "{}";
        }
        String json = JsonUtil.toJsonString(data);
        return json;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public Object getData() {
        return this.data;
    }
}

