/*
 * Decompiled with CFR 0.152.
 */
package framework.proxy;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;

public class MapPropertyProxy
implements MethodInterceptor {
    private final Map<String, Object> map = new HashMap<String, Object>();

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        String name = method.getName();
        if (name.startsWith("get") && args.length == 0) {
            String fieldName = name.substring(3);
            fieldName = Character.toLowerCase(fieldName.charAt(0)) + fieldName.substring(1);
            return this.map.get(fieldName);
        }
        if (name.startsWith("set") && args.length == 1) {
            String fieldName = name.substring(3);
            fieldName = Character.toLowerCase(fieldName.charAt(0)) + fieldName.substring(1);
            this.map.put(fieldName, args[0]);
            return null;
        }
        if (name.equals("properties")) {
            return this.map;
        }
        if (name.startsWith("is") && method.getReturnType() == Boolean.TYPE) {
            throw new RuntimeException(name + " not supported, not allow use boolean type or modify it to Boolean type");
        }
        return proxy.invokeSuper(obj, args);
    }
}

