/*
 * Decompiled with CFR 0.152.
 */
package framework.proxy;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.Column;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;

public class DynamicEntityProxy
implements MethodInterceptor {
    private static final ConcurrentHashMap<String, String> COLUMN_CACHE = new ConcurrentHashMap();
    private final Map<String, Object> map = new HashMap<String, Object>();

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        String name = method.getName();
        if (name.startsWith("get") && args.length == 0) {
            String columnName = this.resolveColumnName(method);
            return this.map.get(columnName);
        }
        if (name.startsWith("set") && args.length == 1) {
            String columnName = this.resolveColumnName(method);
            this.map.put(columnName, args[0]);
            return null;
        }
        if (name.equals("properties")) {
            return this.map;
        }
        if (name.startsWith("is") && method.getReturnType() == Boolean.TYPE) {
            throw new RuntimeException(name + " not supported, not allow use boolean type or modify it to Boolean type");
        }
        return proxy.invokeSuper(obj, args);
    }

    private String resolveColumnName(Method method) {
        Class<?> clazz = method.getDeclaringClass();
        String fn = method.getName().substring(3);
        String fieldName = Character.toLowerCase(fn.charAt(0)) + fn.substring(1);
        return COLUMN_CACHE.computeIfAbsent(clazz.getName() + "#" + fieldName, k -> this.resolveColumnName(clazz, method, fieldName));
    }

    private String resolveColumnName(Class<?> clazz, Method method, String fieldName) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            Column fieldColumn = field.getAnnotation(Column.class);
            if (fieldColumn != null) {
                return fieldColumn.name();
            }
        }
        catch (NoSuchFieldException field) {
            // empty catch block
        }
        Column methodColumn = method.getAnnotation(Column.class);
        if (methodColumn != null) {
            return methodColumn.name();
        }
        return fieldName;
    }
}

