/*
 * Decompiled with CFR 0.152.
 */
package framework.pid;

import framework.order.OrderNumUtil;
import framework.pid.PidOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;

public class PidUtil {
    public static <T extends PidOption> List<T> tree(List<T> list, String topLevel, boolean desc) {
        OrderNumUtil.order(list, desc);
        HashMap<String, PidOption> map = new HashMap<String, PidOption>();
        ArrayList<PidOption> optionList = new ArrayList<PidOption>();
        ArrayList<PidOption> tops = new ArrayList<PidOption>();
        for (PidOption option : list) {
            optionList.add(option);
            if (option.pid() == null || topLevel.equals(option.pid())) {
                tops.add(option);
            }
            map.put(option.id(), option);
        }
        for (PidOption option : optionList) {
            PidOption parent;
            if (option.pid() == null || topLevel.equals(option.pid()) || (parent = (PidOption)map.get(option.pid())) == null) continue;
            parent.getChildren().add(option);
        }
        return tops;
    }

    public static <T extends PidOption> void cleanNonChildren(List<T> list) {
        for (int i = list.size() - 1; i >= 0; --i) {
            PidOption t = (PidOption)list.get(i);
            if (t.getChildren().size() > 0) {
                PidUtil.cleanNonChildren(t.getChildren());
                continue;
            }
            list.remove(i);
        }
    }

    public static <T extends PidOption> void cleanNonChildren(List<T> list, Function<T, Boolean> matcher) {
        for (int i = list.size() - 1; i >= 0; --i) {
            PidOption t = (PidOption)list.get(i);
            if (matcher.apply(t).booleanValue()) {
                list.remove(i);
                continue;
            }
            List<PidOption> children = t.getChildren();
            PidUtil.cleanNonChildren(children, matcher);
        }
    }
}

