/*
 * Decompiled with CFR 0.152.
 */
package framework.io;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.StringUtils;

public class PathListMatcher {
    private final Map<String, String> fullMatchMap = new HashMap<String, String>();
    private final List<String> startMatchList = new ArrayList<String>();
    private final AntPathMatcher antPathMatcher = new AntPathMatcher();

    public PathListMatcher(List<String> paths) {
        for (String path : paths) {
            if (!StringUtils.hasText((String)path)) continue;
            if (this.antPathMatcher.isPattern(path)) {
                this.startMatchList.add(path);
                continue;
            }
            this.fullMatchMap.put(path, path);
        }
        this.startMatchList.sort(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return Integer.compare(o2.length(), o1.length());
            }
        });
    }

    public String match(String path) {
        if (!StringUtils.hasText((String)path)) {
            return null;
        }
        String s = this.fullMatchMap.get(path);
        if (s != null) {
            return s;
        }
        for (String fp : this.startMatchList) {
            if (!this.antPathMatcher.match(fp, path)) continue;
            return fp;
        }
        return null;
    }
}

