/*
 * Decompiled with CFR 0.152.
 */
package framework.io;

import java.io.IOException;
import java.io.OutputStream;

public class FullBufferOutputStream
extends OutputStream {
    protected byte[] buf;
    protected int count;
    protected OutputStream out;

    public FullBufferOutputStream(OutputStream out, int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.out = out;
        this.buf = new byte[size];
    }

    private void flushBuffer() throws IOException {
        if (this.count > 0) {
            this.out.write(this.buf, 0, this.count);
            this.count = 0;
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.count == this.buf.length) {
            this.flushBuffer();
        }
        this.buf[this.count++] = (byte)b;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int writeLength;
        if (b == null) {
            throw new NullPointerException("Write data is null");
        }
        if (off < 0) {
            throw new IndexOutOfBoundsException("Offset is negative");
        }
        if (len < 1) {
            throw new IndexOutOfBoundsException("Length is negative");
        }
        int currentOff = off;
        for (int remainingData = len; remainingData > 0; remainingData -= writeLength) {
            int bufferRemaining = this.buf.length - this.count;
            if (bufferRemaining == 0) {
                this.flushBuffer();
                bufferRemaining = this.buf.length;
            }
            if (currentOff + (writeLength = Math.min(remainingData, bufferRemaining)) > b.length && (writeLength = b.length - currentOff) <= 0) break;
            System.arraycopy(b, currentOff, this.buf, this.count, writeLength);
            this.count += writeLength;
            currentOff += writeLength;
            if (this.count != this.buf.length) continue;
            this.flushBuffer();
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        this.flushBuffer();
    }
}

