/*
 * Decompiled with CFR 0.152.
 */
package framework.exceptions;

import org.springframework.http.HttpStatus;

public class WebException
extends RuntimeException {
    private int _errorCode = 500;

    public int errorCode() {
        return this._errorCode;
    }

    public WebException() {
    }

    public WebException(String message) {
        super(message);
    }

    public WebException(int errorCode, String message) {
        super(message);
        this._errorCode = errorCode;
        HttpStatus status = HttpStatus.resolve((int)errorCode);
        if (status == null) {
            throw new IllegalArgumentException("Invalid error code: " + errorCode + ", must be a HTTP status code");
        }
    }

    public WebException(String message, Throwable cause) {
        super(message, cause);
    }

    public WebException(int errorCode, Throwable cause) {
        super(cause.getMessage(), cause);
        this._errorCode = errorCode;
        HttpStatus status = HttpStatus.resolve((int)errorCode);
        if (status == null) {
            throw new IllegalArgumentException("Invalid error code: " + errorCode + ", must be a HTTP status code");
        }
    }
}

