/*
 * Decompiled with CFR 0.152.
 */
package framework.datatype;

public abstract class DataConvertBase {
    public abstract Object loadDataValue(String var1);

    public String[] getAsArray(String name) {
        return this.getAsArray(name, null, ",");
    }

    public String[] getAsArray(String name, String defaultValue) {
        return this.getAsArray(name, defaultValue, ",");
    }

    public String[] getAsArray(String name, String defaultValue, String separator) {
        String v = this.getAsString(name, defaultValue);
        if (v == null) {
            return null;
        }
        return v.split(separator);
    }

    public String getAsString(String name) {
        return this.getAsString(name, null);
    }

    public String getAsString(String name, String defaultValue) {
        Object v = this.loadDataValue(name);
        if (v == null) {
            return defaultValue;
        }
        if (v instanceof String) {
            return (String)v;
        }
        return v.toString();
    }

    public Byte getAsByte(String name) {
        return this.getAsByte(name, null);
    }

    public Byte getAsByte(String name, Byte defaultValue) {
        Object v = this.loadDataValue(name);
        if (v == null) {
            return defaultValue;
        }
        if (v instanceof Byte) {
            return (Byte)v;
        }
        return Byte.parseByte(v.toString());
    }

    public Short getAsShort(String name) {
        return this.getAsShort(name, null);
    }

    public Short getAsShort(String name, Short defaultValue) {
        Object v = this.loadDataValue(name);
        if (v == null) {
            return defaultValue;
        }
        if (v instanceof Short) {
            return (Short)v;
        }
        return Short.parseShort(v.toString());
    }

    public Integer getAsInt(String name) {
        return this.getAsInt(name, null);
    }

    public Integer getAsInt(String name, Integer defaultValue) {
        Object v = this.loadDataValue(name);
        if (v == null) {
            return defaultValue;
        }
        if (v instanceof Integer) {
            return (Integer)v;
        }
        return Integer.parseInt(v.toString());
    }

    public Long getAsLong(String name) {
        return this.getAsLong(name, null);
    }

    public Long getAsLong(String name, Long defaultValue) {
        Object v = this.loadDataValue(name);
        if (v == null) {
            return defaultValue;
        }
        if (v instanceof Long) {
            return (Long)v;
        }
        return Long.parseLong(v.toString());
    }

    public Double getAsDouble(String name) {
        return this.getAsDouble(name, null);
    }

    public Double getAsDouble(String name, Double defaultValue) {
        Object v = this.loadDataValue(name);
        if (v == null) {
            return defaultValue;
        }
        if (v instanceof Double) {
            return (Double)v;
        }
        return Double.parseDouble(v.toString());
    }

    public Float getAsFloat(String name) {
        return this.getAsFloat(name, null);
    }

    public Float getAsFloat(String name, Float defaultValue) {
        Object v = this.loadDataValue(name);
        if (v == null) {
            return defaultValue;
        }
        if (v instanceof Float) {
            return (Float)v;
        }
        return Float.valueOf(Float.parseFloat(v.toString()));
    }

    public Boolean getAsBoolean(String name) {
        return this.getAsBoolean(name, null);
    }

    public Boolean getAsBoolean(String name, Boolean defaultValue) {
        Object v = this.loadDataValue(name);
        if (v == null) {
            return defaultValue;
        }
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        String s = v.toString();
        if (s.equals("1")) {
            return true;
        }
        if (s.equals("yes")) {
            return true;
        }
        return Boolean.parseBoolean(s);
    }
}

