/*
 * Decompiled with CFR 0.152.
 */
package framework.crypto;

import framework.config.GeneralCryptoConfig;
import framework.crypto.GeneralCrypto;
import framework.exceptions.BusinessException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.URL;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Base64;
import javax.crypto.Cipher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class GeneralCryptoImpl
implements GeneralCrypto {
    private static final Logger log = LoggerFactory.getLogger(GeneralCryptoImpl.class);
    private GeneralCryptoConfig config;
    private PrivateKey privateKey = null;
    private PublicKey publicKey = null;
    private String publicKeyContent = null;

    public GeneralCryptoImpl(GeneralCryptoConfig config) {
        this.config = config;
        this.loadKey();
    }

    private InputStream loadPrivateKey() throws IOException {
        String privateKeyPath = this.config.getPrivateKeyPath();
        if (!StringUtils.hasText((String)privateKeyPath)) {
            throw new BusinessException("Not config sys.crypto.general.private-key-path");
        }
        InputStream inputStream = privateKeyPath.startsWith("file://") ? new URL(privateKeyPath).openStream() : GeneralCryptoConfig.class.getClassLoader().getResourceAsStream(privateKeyPath);
        if (inputStream == null) {
            throw new BusinessException("Not config sys.crypto.general.private-key-path");
        }
        return inputStream;
    }

    private void loadKey() {
        try (InputStream inputStream = this.loadPrivateKey();){
            StringBuffer buffer = new StringBuffer();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));){
                String line = null;
                while ((line = reader.readLine()) != null) {
                    if (line.length() == 0 || line.startsWith("-----")) continue;
                    buffer.append(line);
                }
            }
            String privateKeyContent = buffer.toString();
            byte[] privateKeyBytes = Base64.getDecoder().decode(privateKeyContent);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            this.privateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(privateKeyBytes));
            RSAPrivateKeySpec priv = keyFactory.getKeySpec(this.privateKey, RSAPrivateKeySpec.class);
            RSAPublicKeySpec keySpec = new RSAPublicKeySpec(priv.getModulus(), BigInteger.valueOf(65537L));
            this.publicKey = keyFactory.generatePublic(keySpec);
            byte[] publicKeyBytes = this.publicKey.getEncoded();
            Base64.Encoder mimeEncoder = Base64.getMimeEncoder(64, "\r\n".getBytes());
            this.publicKeyContent = "-----BEGIN PUBLIC KEY-----\r\n" + mimeEncoder.encodeToString(publicKeyBytes) + "\r\n-----END PUBLIC KEY-----";
        }
    }

    @Override
    public byte[] encrypt(byte[] data) {
        Cipher cipher = this.getCipher();
        cipher.init(1, this.publicKey);
        byte[] encryptedBytes = cipher.doFinal(data);
        return encryptedBytes;
    }

    @Override
    public byte[] decrypt(byte[] data) {
        Cipher cipher = this.getCipher();
        cipher.init(2, this.privateKey);
        byte[] decryptedBytes = cipher.doFinal(data);
        return decryptedBytes;
    }

    private Cipher getCipher() {
        Cipher cipher = null;
        cipher = this.config.getProvider() == null ? Cipher.getInstance(this.config.getCipher()) : Cipher.getInstance(this.config.getCipher(), this.config.getProvider());
        return cipher;
    }

    public GeneralCryptoConfig getConfig() {
        return this.config;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    @Override
    public String getPublicKeyContent() {
        return this.publicKeyContent;
    }
}

