/*
 * Decompiled with CFR 0.152.
 */
package framework.crypto;

import framework.config.GeneralCryptoConfig;
import framework.crypto.GeneralCrypto;
import framework.crypto.GeneralCryptoDisabled;
import framework.crypto.GeneralCryptoImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
public class GeneralCryptoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(GeneralCryptoConfiguration.class);

    @Bean
    public GeneralCrypto generalCrypto(GeneralCryptoConfig generalCryptoConfig) {
        if (StringUtils.hasText((String)generalCryptoConfig.getPrivateKeyPath())) {
            GeneralCryptoImpl crypto = new GeneralCryptoImpl(generalCryptoConfig);
            if (crypto.enable()) {
                log.info("GeneralCrypto enabled");
            }
            return crypto;
        }
        return new GeneralCryptoDisabled();
    }
}

