/*
 * Decompiled with CFR 0.152.
 */
package framework.crypto;

import java.nio.charset.StandardCharsets;
import java.util.Base64;

public interface GeneralCrypto {
    default public boolean enable() {
        return true;
    }

    public byte[] encrypt(byte[] var1);

    default public String encryptAsBase64(byte[] data) {
        byte[] encrypt = this.encrypt(data);
        return Base64.getEncoder().encodeToString(encrypt);
    }

    default public String encryptAsBase64(String data) {
        byte[] encrypt = this.encrypt(data.getBytes(StandardCharsets.UTF_8));
        return Base64.getEncoder().encodeToString(encrypt);
    }

    default public String encrypt(String data) {
        byte[] encrypt = this.encrypt(data.getBytes(StandardCharsets.UTF_8));
        return new String(encrypt);
    }

    public byte[] decrypt(byte[] var1);

    default public String decryptAsString(byte[] data) {
        byte[] decryptedBytes = this.decrypt(data);
        return new String(decryptedBytes, "UTF-8");
    }

    default public String decryptAsString(String data) {
        byte[] bytes = data.getBytes(StandardCharsets.UTF_8);
        byte[] decryptedBytes = this.decrypt(bytes);
        return new String(decryptedBytes, "UTF-8");
    }

    default public byte[] decryptFromBase64(String base64) {
        byte[] bytes = Base64.getDecoder().decode(base64);
        byte[] decryptedBytes = this.decrypt(bytes);
        return decryptedBytes;
    }

    default public String decryptFromBase64AsString(String base64) {
        byte[] bytes = Base64.getDecoder().decode(base64);
        byte[] decryptedBytes = this.decrypt(bytes);
        return new String(decryptedBytes, "UTF-8");
    }

    public String getPublicKeyContent();
}

