/*
 * Decompiled with CFR 0.152.
 */
package framework.crypto;

import framework.config.AESCryptoConfig;
import framework.crypto.AESCrypto;
import framework.crypto.AESCryptoImpl;
import framework.exceptions.ConfigurationException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.crypto.Cipher;
import org.apache.commons.lang3.StringUtils;

public class AESCryptoPlus
implements AESCrypto {
    private final String algorithm;
    private final String cipherAlgorithm;
    private final String secretKey;
    private Integer secretIndex = 0;
    private final List<AESCrypto> cryptoList = new CopyOnWriteArrayList<AESCrypto>();

    public AESCryptoPlus(AESCryptoConfig config) {
        if (StringUtils.isBlank((CharSequence)config.getAlgorithm())) {
            throw new ConfigurationException("Not config algorithm");
        }
        if (StringUtils.isBlank((CharSequence)config.getCipherAlgorithm())) {
            throw new ConfigurationException("Not config cipher algorithm");
        }
        if (StringUtils.isBlank((CharSequence)config.getSecretKey())) {
            throw new ConfigurationException("Not config secret key");
        }
        if (config.getSecretIndex() == null) {
            throw new ConfigurationException("Not config secret index, please use AESCryptoImpl instead of AESCryptoPlus");
        }
        if (config.getSecretIndex() < 0) {
            throw new ConfigurationException("Secret index min allow 0");
        }
        if (config.getSecretIndex() > 99) {
            throw new ConfigurationException("Secret index max allow 99");
        }
        String[] keys = config.getSecretKey().split(",");
        if (config.getSecretIndex() > keys.length - 1) {
            throw new ConfigurationException("Secret index exceeds Secret key length");
        }
        this.secretIndex = config.getSecretIndex();
        this.algorithm = config.getAlgorithm();
        this.cipherAlgorithm = config.getCipherAlgorithm();
        this.secretKey = config.getSecretKey();
        for (String k : keys) {
            AESCryptoConfig cryptoConfig = new AESCryptoConfig();
            cryptoConfig.setAlgorithm(this.algorithm);
            cryptoConfig.setCipherAlgorithm(this.cipherAlgorithm);
            cryptoConfig.setSecretKey(k);
            this.cryptoList.add(this.createAESCrypto(cryptoConfig));
        }
    }

    protected AESCrypto createAESCrypto(AESCryptoConfig cryptoConfig) {
        return new AESCryptoImpl(cryptoConfig);
    }

    @Override
    public Cipher getEncodeCipher() {
        List<AESCrypto> cryptoList = this.getCryptoList();
        AESCrypto crypto = cryptoList.get(this.secretIndex);
        return crypto.getEncodeCipher();
    }

    @Override
    public Cipher getDecodeCipher(byte[] encryptedData) {
        if (encryptedData.length < 2) {
            throw new IllegalArgumentException("encryptedData invalid");
        }
        List<AESCrypto> cryptoList = this.getCryptoList();
        byte index = encryptedData[encryptedData.length - 1];
        if (index < 0 || index > 99) {
            throw new IllegalArgumentException("encryptedData invalid");
        }
        AESCrypto crypto = cryptoList.get(index);
        return crypto.getDecodeCipher(encryptedData);
    }

    @Override
    public byte[] encode(byte[] content) {
        Cipher cipher = this.getEncodeCipher();
        byte[] d = cipher.doFinal(content);
        byte[] iv = cipher.getIV();
        byte[] buf = new byte[d.length + iv.length + 1];
        System.arraycopy(iv, 0, buf, 0, iv.length);
        System.arraycopy(d, 0, buf, iv.length, d.length);
        buf[buf.length - 1] = this.secretIndex.byteValue();
        return buf;
    }

    @Override
    public byte[] decode(byte[] content) {
        Cipher cipher = this.getDecodeCipher(content);
        byte[] iv = cipher.getIV();
        byte[] data = new byte[content.length - iv.length - 1];
        System.arraycopy(content, iv.length, data, 0, data.length);
        return cipher.doFinal(data);
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getCipherAlgorithm() {
        return this.cipherAlgorithm;
    }

    @Override
    public String getSecretKey() {
        return this.secretKey;
    }

    public List<AESCrypto> getCryptoList() {
        return this.cryptoList;
    }
}

