/*
 * Decompiled with CFR 0.152.
 */
package framework.crypto;

import framework.config.AESCryptoConfig;
import framework.crypto.AESCrypto;
import framework.exceptions.ConfigurationException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Date;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;

public class AESCryptoImpl
implements AESCrypto {
    private static final int GCM_LENGTH = 128;
    private final String algorithm;
    private final String cipherAlgorithm;
    private final String secretKey;
    private final byte[] secretData;
    private final SecureRandom secureRandom = new SecureRandom();
    private final int ivLength;

    public AESCryptoImpl(AESCryptoConfig config) {
        if (StringUtils.isBlank((CharSequence)config.getAlgorithm())) {
            throw new ConfigurationException("Not config algorithm");
        }
        if (StringUtils.isBlank((CharSequence)config.getCipherAlgorithm())) {
            throw new ConfigurationException("Not config cipher algorithm");
        }
        if (StringUtils.isBlank((CharSequence)config.getSecretKey())) {
            throw new ConfigurationException("Not config secret key");
        }
        this.algorithm = config.getAlgorithm();
        this.cipherAlgorithm = config.getCipherAlgorithm();
        this.secretKey = config.getSecretKey();
        this.secretData = config.getSecretKey().getBytes(StandardCharsets.UTF_8);
        SecretKeySpec secretKey = new SecretKeySpec(this.secretData, this.algorithm);
        Cipher cipher = Cipher.getInstance(this.cipherAlgorithm);
        cipher.init(1, (Key)secretKey, this.secureRandom);
        this.ivLength = cipher.getIV().length;
    }

    public AESCryptoImpl(String secretKey) {
        this(new AESCryptoConfig(secretKey));
    }

    @Override
    public Cipher getEncodeCipher() {
        SecretKeySpec secretKey = new SecretKeySpec(this.secretData, this.algorithm);
        Cipher cipher = Cipher.getInstance(this.cipherAlgorithm);
        if ("GCM".equals(cipher.getParameters().getAlgorithm())) {
            byte[] ivBytes = new byte[this.ivLength];
            this.secureRandom.nextBytes(ivBytes);
            cipher.init(1, (Key)secretKey, new GCMParameterSpec(128, ivBytes));
        } else {
            cipher.init(1, (Key)secretKey, this.secureRandom);
        }
        return cipher;
    }

    @Override
    public Cipher getDecodeCipher(byte[] encryptedData) {
        SecretKeySpec secretKey = new SecretKeySpec(this.secretData, this.algorithm);
        Cipher cipher = Cipher.getInstance(this.cipherAlgorithm);
        byte[] iv = new byte[this.ivLength];
        System.arraycopy(encryptedData, 0, iv, 0, iv.length);
        if ("GCM".equals(cipher.getParameters().getAlgorithm())) {
            cipher.init(2, (Key)secretKey, new GCMParameterSpec(128, iv));
        } else {
            cipher.init(2, (Key)secretKey, new IvParameterSpec(iv));
        }
        return cipher;
    }

    public static void main(String[] args) {
        String secretKey = "6D9810A918FD43D0B180D89E4D195410";
        AESCryptoImpl crypto = new AESCryptoImpl(secretKey);
        String password = "1234567890";
        String encrypt = crypto.encodeHex(password);
        System.out.println("encrypt: " + encrypt);
        String decrypt = crypto.decodeHex(encrypt);
        System.out.println("decrypt: " + decrypt);
        encrypt = crypto.encodeHex(password);
        System.out.println("encrypt: " + encrypt);
        decrypt = crypto.decodeHex(encrypt);
        System.out.println("decrypt: " + decrypt);
        System.out.println("======================");
        encrypt = crypto.encodeBase64(password);
        System.out.println("encrypt: " + encrypt);
        decrypt = crypto.decodeBase64AsString(encrypt);
        System.out.println("decrypt: " + decrypt);
        encrypt = crypto.encodeBase64(password);
        System.out.println("encrypt: " + encrypt);
        decrypt = crypto.decodeBase64AsString(encrypt);
        System.out.println("decrypt: " + decrypt);
        System.out.println("======================");
        encrypt = crypto.encodeUrlBase64(password);
        System.out.println("encrypt: " + encrypt);
        decrypt = crypto.decodeUrlBase64AsString(encrypt);
        System.out.println("decrypt: " + decrypt);
        encrypt = crypto.encodeUrlBase64(password);
        System.out.println("encrypt: " + encrypt);
        decrypt = crypto.decodeUrlBase64AsString(encrypt);
        System.out.println("decrypt: " + decrypt);
        System.out.println("======================");
        Long l1 = 123456789L;
        Long l2 = new Date().getTime() / 1000L;
        byte[] b1 = ByteBuffer.allocate(32).putLong(0, l1).putLong(8, l2).array();
        encrypt = crypto.encodeHex(b1);
        System.out.println("l1: " + l1);
        System.out.println("l2: " + l2);
        System.out.println("encrypt: " + encrypt + " ,len: " + encrypt.length());
        b1 = crypto.decode(encrypt);
        ByteBuffer buffer = ByteBuffer.wrap(b1);
        l1 = buffer.getLong(0);
        l2 = buffer.getLong(8);
        System.out.println("l1: " + l1);
        System.out.println("l2: " + l2);
        System.out.println("======================");
        encrypt = crypto.encodeUrlBase64(b1);
        System.out.println("l1: " + l1);
        System.out.println("l2: " + l2);
        System.out.println("encrypt: " + encrypt + " ,len: " + encrypt.length());
        b1 = crypto.decodeUrlBase64(encrypt);
        buffer = ByteBuffer.wrap(b1);
        l1 = buffer.getLong(0);
        l2 = buffer.getLong(8);
        System.out.println("l1: " + l1);
        System.out.println("l2: " + l2);
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getCipherAlgorithm() {
        return this.cipherAlgorithm;
    }

    @Override
    public String getSecretKey() {
        return this.secretKey;
    }
}

