/*
 * Decompiled with CFR 0.152.
 */
package framework.crypto;

import framework.config.AESCryptoConfig;
import framework.crypto.AESCrypto;
import framework.crypto.AESCryptoDisabled;
import framework.crypto.AESCryptoImpl;
import framework.crypto.AESCryptoPlus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
public class AESCryptoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(AESCryptoConfiguration.class);

    @Bean
    public AESCrypto aesCrypto(AESCryptoConfig config) {
        if (StringUtils.hasText((String)config.getSecretKey())) {
            AESCryptoImpl crypto;
            AESCrypto aESCrypto = crypto = config.getSecretIndex() != null && config.getSecretIndex() > -1 ? new AESCryptoPlus(config) : new AESCryptoImpl(config);
            if (crypto.enable()) {
                log.info("AESCrypto enabled");
            }
            return crypto;
        }
        return new AESCryptoDisabled();
    }
}

