/*
 * Decompiled with CFR 0.152.
 */
package framework.crypto;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Hex;

public interface AESCrypto {
    default public String getAlgorithm() {
        return "AES";
    }

    default public String getCipherAlgorithm() {
        return "AES/GCM/NoPadding";
    }

    public String getSecretKey();

    default public byte[] encode(byte[] content) {
        Cipher cipher = this.getEncodeCipher();
        byte[] d = cipher.doFinal(content);
        byte[] iv = cipher.getIV();
        byte[] buf = new byte[d.length + iv.length];
        System.arraycopy(iv, 0, buf, 0, iv.length);
        System.arraycopy(d, 0, buf, iv.length, d.length);
        return buf;
    }

    default public byte[] decode(byte[] content) {
        Cipher cipher = this.getDecodeCipher(content);
        byte[] iv = cipher.getIV();
        byte[] data = new byte[content.length - iv.length];
        System.arraycopy(content, iv.length, data, 0, data.length);
        return cipher.doFinal(data);
    }

    default public String encodeHex(String content) {
        byte[] contentBytes = content.getBytes(StandardCharsets.UTF_8);
        byte[] bytes = this.encode(contentBytes);
        return Hex.encodeHexString((byte[])bytes);
    }

    default public String encodeHex(byte[] content) {
        byte[] bytes = this.encode(content);
        return Hex.encodeHexString((byte[])bytes);
    }

    default public String encodeBase64(byte[] content) {
        byte[] bytes = this.encode(content);
        return Base64.getEncoder().encodeToString(bytes);
    }

    default public String encodeBase64(String content) {
        if (content == null) {
            throw new IllegalArgumentException("content is null");
        }
        return this.encodeBase64(content.getBytes(StandardCharsets.UTF_8));
    }

    default public String encodeUrlBase64(byte[] content) {
        byte[] bytes = this.encode(content);
        return Base64.getUrlEncoder().withoutPadding().encodeToString(bytes);
    }

    default public String encodeUrlBase64(String content) {
        if (content == null) {
            throw new IllegalArgumentException("content is null");
        }
        return this.encodeUrlBase64(content.getBytes(StandardCharsets.UTF_8));
    }

    default public String decodeHex(String content) {
        return new String(this.decode(content), StandardCharsets.UTF_8);
    }

    default public byte[] decode(String hexContent) {
        byte[] contentBytes = Hex.decodeHex((String)hexContent);
        return this.decode(contentBytes);
    }

    default public byte[] decodeBase64(String base64Content) {
        byte[] contentBytes = Base64.getDecoder().decode(base64Content);
        return this.decode(contentBytes);
    }

    default public String decodeBase64AsString(String base64Content) {
        byte[] base64 = this.decodeBase64(base64Content);
        if (base64 == null) {
            return null;
        }
        return new String(base64, StandardCharsets.UTF_8);
    }

    default public byte[] decodeUrlBase64(String base64Content) {
        byte[] contentBytes = Base64.getUrlDecoder().decode(base64Content);
        return this.decode(contentBytes);
    }

    default public String decodeUrlBase64AsString(String base64Content) {
        byte[] base64 = this.decodeUrlBase64(base64Content);
        if (base64 == null) {
            return null;
        }
        return new String(base64, StandardCharsets.UTF_8);
    }

    public Cipher getEncodeCipher();

    public Cipher getDecodeCipher(byte[] var1);

    default public boolean enable() {
        return true;
    }
}

