/*
 * Decompiled with CFR 0.152.
 */
package framework.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="sys.user")
public class UserConfig {
    private Long superAdminId = 1L;
    private Integer superAdminPasswordChange = 0;
    private Integer adminRoleId = 1;
    private Integer loginFailCounterExpireSeconds = 300;
    private Integer loginFailMaxLimit = 5;
    private Integer passwordDefaultExpireDay = 90;
    private Integer defaultRoleId = 0;

    public boolean checkIsSuperAdminId(Long userId) {
        if (userId == null) {
            return false;
        }
        if (this.getSuperAdminId() == null) {
            return false;
        }
        return userId.equals(this.getSuperAdminId());
    }

    public Long getSuperAdminId() {
        return this.superAdminId;
    }

    public Integer getSuperAdminPasswordChange() {
        return this.superAdminPasswordChange;
    }

    public Integer getAdminRoleId() {
        return this.adminRoleId;
    }

    public Integer getLoginFailCounterExpireSeconds() {
        return this.loginFailCounterExpireSeconds;
    }

    public Integer getLoginFailMaxLimit() {
        return this.loginFailMaxLimit;
    }

    public Integer getPasswordDefaultExpireDay() {
        return this.passwordDefaultExpireDay;
    }

    public Integer getDefaultRoleId() {
        return this.defaultRoleId;
    }

    public void setSuperAdminId(Long superAdminId) {
        this.superAdminId = superAdminId;
    }

    public void setSuperAdminPasswordChange(Integer superAdminPasswordChange) {
        this.superAdminPasswordChange = superAdminPasswordChange;
    }

    public void setAdminRoleId(Integer adminRoleId) {
        this.adminRoleId = adminRoleId;
    }

    public void setLoginFailCounterExpireSeconds(Integer loginFailCounterExpireSeconds) {
        this.loginFailCounterExpireSeconds = loginFailCounterExpireSeconds;
    }

    public void setLoginFailMaxLimit(Integer loginFailMaxLimit) {
        this.loginFailMaxLimit = loginFailMaxLimit;
    }

    public void setPasswordDefaultExpireDay(Integer passwordDefaultExpireDay) {
        this.passwordDefaultExpireDay = passwordDefaultExpireDay;
    }

    public void setDefaultRoleId(Integer defaultRoleId) {
        this.defaultRoleId = defaultRoleId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserConfig)) {
            return false;
        }
        UserConfig other = (UserConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$superAdminId = this.getSuperAdminId();
        Long other$superAdminId = other.getSuperAdminId();
        if (this$superAdminId == null ? other$superAdminId != null : !((Object)this$superAdminId).equals(other$superAdminId)) {
            return false;
        }
        Integer this$superAdminPasswordChange = this.getSuperAdminPasswordChange();
        Integer other$superAdminPasswordChange = other.getSuperAdminPasswordChange();
        if (this$superAdminPasswordChange == null ? other$superAdminPasswordChange != null : !((Object)this$superAdminPasswordChange).equals(other$superAdminPasswordChange)) {
            return false;
        }
        Integer this$adminRoleId = this.getAdminRoleId();
        Integer other$adminRoleId = other.getAdminRoleId();
        if (this$adminRoleId == null ? other$adminRoleId != null : !((Object)this$adminRoleId).equals(other$adminRoleId)) {
            return false;
        }
        Integer this$loginFailCounterExpireSeconds = this.getLoginFailCounterExpireSeconds();
        Integer other$loginFailCounterExpireSeconds = other.getLoginFailCounterExpireSeconds();
        if (this$loginFailCounterExpireSeconds == null ? other$loginFailCounterExpireSeconds != null : !((Object)this$loginFailCounterExpireSeconds).equals(other$loginFailCounterExpireSeconds)) {
            return false;
        }
        Integer this$loginFailMaxLimit = this.getLoginFailMaxLimit();
        Integer other$loginFailMaxLimit = other.getLoginFailMaxLimit();
        if (this$loginFailMaxLimit == null ? other$loginFailMaxLimit != null : !((Object)this$loginFailMaxLimit).equals(other$loginFailMaxLimit)) {
            return false;
        }
        Integer this$passwordDefaultExpireDay = this.getPasswordDefaultExpireDay();
        Integer other$passwordDefaultExpireDay = other.getPasswordDefaultExpireDay();
        if (this$passwordDefaultExpireDay == null ? other$passwordDefaultExpireDay != null : !((Object)this$passwordDefaultExpireDay).equals(other$passwordDefaultExpireDay)) {
            return false;
        }
        Integer this$defaultRoleId = this.getDefaultRoleId();
        Integer other$defaultRoleId = other.getDefaultRoleId();
        return !(this$defaultRoleId == null ? other$defaultRoleId != null : !((Object)this$defaultRoleId).equals(other$defaultRoleId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UserConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $superAdminId = this.getSuperAdminId();
        result = result * 59 + ($superAdminId == null ? 43 : ((Object)$superAdminId).hashCode());
        Integer $superAdminPasswordChange = this.getSuperAdminPasswordChange();
        result = result * 59 + ($superAdminPasswordChange == null ? 43 : ((Object)$superAdminPasswordChange).hashCode());
        Integer $adminRoleId = this.getAdminRoleId();
        result = result * 59 + ($adminRoleId == null ? 43 : ((Object)$adminRoleId).hashCode());
        Integer $loginFailCounterExpireSeconds = this.getLoginFailCounterExpireSeconds();
        result = result * 59 + ($loginFailCounterExpireSeconds == null ? 43 : ((Object)$loginFailCounterExpireSeconds).hashCode());
        Integer $loginFailMaxLimit = this.getLoginFailMaxLimit();
        result = result * 59 + ($loginFailMaxLimit == null ? 43 : ((Object)$loginFailMaxLimit).hashCode());
        Integer $passwordDefaultExpireDay = this.getPasswordDefaultExpireDay();
        result = result * 59 + ($passwordDefaultExpireDay == null ? 43 : ((Object)$passwordDefaultExpireDay).hashCode());
        Integer $defaultRoleId = this.getDefaultRoleId();
        result = result * 59 + ($defaultRoleId == null ? 43 : ((Object)$defaultRoleId).hashCode());
        return result;
    }

    public String toString() {
        return "UserConfig(superAdminId=" + this.getSuperAdminId() + ", superAdminPasswordChange=" + this.getSuperAdminPasswordChange() + ", adminRoleId=" + this.getAdminRoleId() + ", loginFailCounterExpireSeconds=" + this.getLoginFailCounterExpireSeconds() + ", loginFailMaxLimit=" + this.getLoginFailMaxLimit() + ", passwordDefaultExpireDay=" + this.getPasswordDefaultExpireDay() + ", defaultRoleId=" + this.getDefaultRoleId() + ")";
    }
}

