/*
 * Decompiled with CFR 0.152.
 */
package framework.config;

import framework.runtime.SystemContext;
import framework.utils.PathUtil;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="server.servlet")
public class ServletConfig {
    private String contextPath;
    private static ServletConfig _instance = null;

    private static ServletConfig instance() {
        if (_instance == null) {
            _instance = SystemContext.getBean(ServletConfig.class);
        }
        return _instance;
    }

    public static String getAppPath(String path) {
        String s1 = PathUtil.removeFirstSlash(path);
        String s2 = PathUtil.removeEndSlash(ServletConfig.instance().contextPath) + "/" + s1;
        return s2;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServletConfig)) {
            return false;
        }
        ServletConfig other = (ServletConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$contextPath = this.getContextPath();
        String other$contextPath = other.getContextPath();
        return !(this$contextPath == null ? other$contextPath != null : !this$contextPath.equals(other$contextPath));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServletConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $contextPath = this.getContextPath();
        result = result * 59 + ($contextPath == null ? 43 : $contextPath.hashCode());
        return result;
    }

    public String toString() {
        return "ServletConfig(contextPath=" + this.getContextPath() + ")";
    }
}

