/*
 * Decompiled with CFR 0.152.
 */
package framework.config;

import framework.exceptions.BusinessException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="sys.security")
public class SecurityConfig
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(SecurityConfig.class);
    private String authIdentityHeader = "X-AUTH-IDENTITY";
    private Integer tokenExpirationReminderSeconds = 0;
    private Double tokenExpirationReminderPercent = 0.0;
    private String tokenExpirationReminderHeader = "X-TOKEN-EXPIRES";
    private String tokenBalanceOutputHeader;
    private Long debugAccountId;
    private String passwordMode;
    private String tokenSecret;
    private Integer tokenSecretIndex = 0;
    private Integer tokenSeconds;
    private String loginPath = "/auth/login";
    private String logoutPath = "/auth/logout";
    private Boolean enableBasicAuth = false;
    private Boolean enableWwwAuthenticate = false;
    private Boolean enableBearerToken = true;
    private Boolean enable = true;
    private String cookiePath = null;
    private String cookieDomain = null;
    private Boolean cookieSecure = false;
    private Boolean cookieHttpOnly = false;
    private Integer cookieMaxAge;
    private Integer cookieTokenRenew = 0;
    private String cookieSameSite;
    private String tokenParamName = "TOKEN";
    private Integer rememberMeMaxSeconds = 0;
    private Boolean enableLoginCaptcha = false;
    private Boolean enableCsrf = false;
    private String pathAuthList = null;
    private String pathAnonList = null;
    private String redirectOnAuthError = null;
    private String redirectOnAuthFailed = null;
    private String redirectOnAuthSuccess = null;
    private String redirectOnLogoutSuccess = null;
    private String redirectOnNoAuth = null;
    private String redirectOnNoPermission = null;
    private Boolean corsAuth = false;

    public void afterPropertiesSet() {
        if (this.tokenSecret == null || this.tokenSecret.isEmpty()) {
            try {
                StringBuffer buffer = new StringBuffer();
                String hostName = InetAddress.getLocalHost().getHostName();
                Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
                while (nis.hasMoreElements()) {
                    NetworkInterface ni = nis.nextElement();
                    String displayName = ni.getDisplayName();
                    buffer.append(displayName).append("\n");
                    Enumeration<InetAddress> inetAddresses = ni.getInetAddresses();
                    while (inetAddresses.hasMoreElements()) {
                        InetAddress inetAddress = inetAddresses.nextElement();
                        String hostAddress = inetAddress.getHostAddress();
                        buffer.append(hostAddress).append("\n");
                    }
                }
                this.tokenSecret = DigestUtils.md5Hex((String)buffer.toString());
                log.warn("Generate dynamic security key: " + this.tokenSecret + ", your can fixed config token-secret in application.yml");
            }
            catch (Exception exception) {
                throw new BusinessException("Generate security.token-secret failed, your can config token-secret in application.yml", (Throwable)exception);
            }
        }
    }

    public String getAuthIdentityHeader() {
        return this.authIdentityHeader;
    }

    public Integer getTokenExpirationReminderSeconds() {
        return this.tokenExpirationReminderSeconds;
    }

    public Double getTokenExpirationReminderPercent() {
        return this.tokenExpirationReminderPercent;
    }

    public String getTokenExpirationReminderHeader() {
        return this.tokenExpirationReminderHeader;
    }

    public String getTokenBalanceOutputHeader() {
        return this.tokenBalanceOutputHeader;
    }

    public Long getDebugAccountId() {
        return this.debugAccountId;
    }

    public String getPasswordMode() {
        return this.passwordMode;
    }

    public String getTokenSecret() {
        return this.tokenSecret;
    }

    public Integer getTokenSecretIndex() {
        return this.tokenSecretIndex;
    }

    public Integer getTokenSeconds() {
        return this.tokenSeconds;
    }

    public String getLoginPath() {
        return this.loginPath;
    }

    public String getLogoutPath() {
        return this.logoutPath;
    }

    public Boolean getEnableBasicAuth() {
        return this.enableBasicAuth;
    }

    public Boolean getEnableWwwAuthenticate() {
        return this.enableWwwAuthenticate;
    }

    public Boolean getEnableBearerToken() {
        return this.enableBearerToken;
    }

    public Boolean getEnable() {
        return this.enable;
    }

    public String getCookiePath() {
        return this.cookiePath;
    }

    public String getCookieDomain() {
        return this.cookieDomain;
    }

    public Boolean getCookieSecure() {
        return this.cookieSecure;
    }

    public Boolean getCookieHttpOnly() {
        return this.cookieHttpOnly;
    }

    public Integer getCookieMaxAge() {
        return this.cookieMaxAge;
    }

    public Integer getCookieTokenRenew() {
        return this.cookieTokenRenew;
    }

    public String getCookieSameSite() {
        return this.cookieSameSite;
    }

    public String getTokenParamName() {
        return this.tokenParamName;
    }

    public Integer getRememberMeMaxSeconds() {
        return this.rememberMeMaxSeconds;
    }

    public Boolean getEnableLoginCaptcha() {
        return this.enableLoginCaptcha;
    }

    public Boolean getEnableCsrf() {
        return this.enableCsrf;
    }

    public String getPathAuthList() {
        return this.pathAuthList;
    }

    public String getPathAnonList() {
        return this.pathAnonList;
    }

    public String getRedirectOnAuthError() {
        return this.redirectOnAuthError;
    }

    public String getRedirectOnAuthFailed() {
        return this.redirectOnAuthFailed;
    }

    public String getRedirectOnAuthSuccess() {
        return this.redirectOnAuthSuccess;
    }

    public String getRedirectOnLogoutSuccess() {
        return this.redirectOnLogoutSuccess;
    }

    public String getRedirectOnNoAuth() {
        return this.redirectOnNoAuth;
    }

    public String getRedirectOnNoPermission() {
        return this.redirectOnNoPermission;
    }

    public Boolean getCorsAuth() {
        return this.corsAuth;
    }

    public void setAuthIdentityHeader(String authIdentityHeader) {
        this.authIdentityHeader = authIdentityHeader;
    }

    public void setTokenExpirationReminderSeconds(Integer tokenExpirationReminderSeconds) {
        this.tokenExpirationReminderSeconds = tokenExpirationReminderSeconds;
    }

    public void setTokenExpirationReminderPercent(Double tokenExpirationReminderPercent) {
        this.tokenExpirationReminderPercent = tokenExpirationReminderPercent;
    }

    public void setTokenExpirationReminderHeader(String tokenExpirationReminderHeader) {
        this.tokenExpirationReminderHeader = tokenExpirationReminderHeader;
    }

    public void setTokenBalanceOutputHeader(String tokenBalanceOutputHeader) {
        this.tokenBalanceOutputHeader = tokenBalanceOutputHeader;
    }

    public void setDebugAccountId(Long debugAccountId) {
        this.debugAccountId = debugAccountId;
    }

    public void setPasswordMode(String passwordMode) {
        this.passwordMode = passwordMode;
    }

    public void setTokenSecret(String tokenSecret) {
        this.tokenSecret = tokenSecret;
    }

    public void setTokenSecretIndex(Integer tokenSecretIndex) {
        this.tokenSecretIndex = tokenSecretIndex;
    }

    public void setTokenSeconds(Integer tokenSeconds) {
        this.tokenSeconds = tokenSeconds;
    }

    public void setLoginPath(String loginPath) {
        this.loginPath = loginPath;
    }

    public void setLogoutPath(String logoutPath) {
        this.logoutPath = logoutPath;
    }

    public void setEnableBasicAuth(Boolean enableBasicAuth) {
        this.enableBasicAuth = enableBasicAuth;
    }

    public void setEnableWwwAuthenticate(Boolean enableWwwAuthenticate) {
        this.enableWwwAuthenticate = enableWwwAuthenticate;
    }

    public void setEnableBearerToken(Boolean enableBearerToken) {
        this.enableBearerToken = enableBearerToken;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public void setCookiePath(String cookiePath) {
        this.cookiePath = cookiePath;
    }

    public void setCookieDomain(String cookieDomain) {
        this.cookieDomain = cookieDomain;
    }

    public void setCookieSecure(Boolean cookieSecure) {
        this.cookieSecure = cookieSecure;
    }

    public void setCookieHttpOnly(Boolean cookieHttpOnly) {
        this.cookieHttpOnly = cookieHttpOnly;
    }

    public void setCookieMaxAge(Integer cookieMaxAge) {
        this.cookieMaxAge = cookieMaxAge;
    }

    public void setCookieTokenRenew(Integer cookieTokenRenew) {
        this.cookieTokenRenew = cookieTokenRenew;
    }

    public void setCookieSameSite(String cookieSameSite) {
        this.cookieSameSite = cookieSameSite;
    }

    public void setTokenParamName(String tokenParamName) {
        this.tokenParamName = tokenParamName;
    }

    public void setRememberMeMaxSeconds(Integer rememberMeMaxSeconds) {
        this.rememberMeMaxSeconds = rememberMeMaxSeconds;
    }

    public void setEnableLoginCaptcha(Boolean enableLoginCaptcha) {
        this.enableLoginCaptcha = enableLoginCaptcha;
    }

    public void setEnableCsrf(Boolean enableCsrf) {
        this.enableCsrf = enableCsrf;
    }

    public void setPathAuthList(String pathAuthList) {
        this.pathAuthList = pathAuthList;
    }

    public void setPathAnonList(String pathAnonList) {
        this.pathAnonList = pathAnonList;
    }

    public void setRedirectOnAuthError(String redirectOnAuthError) {
        this.redirectOnAuthError = redirectOnAuthError;
    }

    public void setRedirectOnAuthFailed(String redirectOnAuthFailed) {
        this.redirectOnAuthFailed = redirectOnAuthFailed;
    }

    public void setRedirectOnAuthSuccess(String redirectOnAuthSuccess) {
        this.redirectOnAuthSuccess = redirectOnAuthSuccess;
    }

    public void setRedirectOnLogoutSuccess(String redirectOnLogoutSuccess) {
        this.redirectOnLogoutSuccess = redirectOnLogoutSuccess;
    }

    public void setRedirectOnNoAuth(String redirectOnNoAuth) {
        this.redirectOnNoAuth = redirectOnNoAuth;
    }

    public void setRedirectOnNoPermission(String redirectOnNoPermission) {
        this.redirectOnNoPermission = redirectOnNoPermission;
    }

    public void setCorsAuth(Boolean corsAuth) {
        this.corsAuth = corsAuth;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SecurityConfig)) {
            return false;
        }
        SecurityConfig other = (SecurityConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$tokenExpirationReminderSeconds = this.getTokenExpirationReminderSeconds();
        Integer other$tokenExpirationReminderSeconds = other.getTokenExpirationReminderSeconds();
        if (this$tokenExpirationReminderSeconds == null ? other$tokenExpirationReminderSeconds != null : !((Object)this$tokenExpirationReminderSeconds).equals(other$tokenExpirationReminderSeconds)) {
            return false;
        }
        Double this$tokenExpirationReminderPercent = this.getTokenExpirationReminderPercent();
        Double other$tokenExpirationReminderPercent = other.getTokenExpirationReminderPercent();
        if (this$tokenExpirationReminderPercent == null ? other$tokenExpirationReminderPercent != null : !((Object)this$tokenExpirationReminderPercent).equals(other$tokenExpirationReminderPercent)) {
            return false;
        }
        Long this$debugAccountId = this.getDebugAccountId();
        Long other$debugAccountId = other.getDebugAccountId();
        if (this$debugAccountId == null ? other$debugAccountId != null : !((Object)this$debugAccountId).equals(other$debugAccountId)) {
            return false;
        }
        Integer this$tokenSecretIndex = this.getTokenSecretIndex();
        Integer other$tokenSecretIndex = other.getTokenSecretIndex();
        if (this$tokenSecretIndex == null ? other$tokenSecretIndex != null : !((Object)this$tokenSecretIndex).equals(other$tokenSecretIndex)) {
            return false;
        }
        Integer this$tokenSeconds = this.getTokenSeconds();
        Integer other$tokenSeconds = other.getTokenSeconds();
        if (this$tokenSeconds == null ? other$tokenSeconds != null : !((Object)this$tokenSeconds).equals(other$tokenSeconds)) {
            return false;
        }
        Boolean this$enableBasicAuth = this.getEnableBasicAuth();
        Boolean other$enableBasicAuth = other.getEnableBasicAuth();
        if (this$enableBasicAuth == null ? other$enableBasicAuth != null : !((Object)this$enableBasicAuth).equals(other$enableBasicAuth)) {
            return false;
        }
        Boolean this$enableWwwAuthenticate = this.getEnableWwwAuthenticate();
        Boolean other$enableWwwAuthenticate = other.getEnableWwwAuthenticate();
        if (this$enableWwwAuthenticate == null ? other$enableWwwAuthenticate != null : !((Object)this$enableWwwAuthenticate).equals(other$enableWwwAuthenticate)) {
            return false;
        }
        Boolean this$enableBearerToken = this.getEnableBearerToken();
        Boolean other$enableBearerToken = other.getEnableBearerToken();
        if (this$enableBearerToken == null ? other$enableBearerToken != null : !((Object)this$enableBearerToken).equals(other$enableBearerToken)) {
            return false;
        }
        Boolean this$enable = this.getEnable();
        Boolean other$enable = other.getEnable();
        if (this$enable == null ? other$enable != null : !((Object)this$enable).equals(other$enable)) {
            return false;
        }
        Boolean this$cookieSecure = this.getCookieSecure();
        Boolean other$cookieSecure = other.getCookieSecure();
        if (this$cookieSecure == null ? other$cookieSecure != null : !((Object)this$cookieSecure).equals(other$cookieSecure)) {
            return false;
        }
        Boolean this$cookieHttpOnly = this.getCookieHttpOnly();
        Boolean other$cookieHttpOnly = other.getCookieHttpOnly();
        if (this$cookieHttpOnly == null ? other$cookieHttpOnly != null : !((Object)this$cookieHttpOnly).equals(other$cookieHttpOnly)) {
            return false;
        }
        Integer this$cookieMaxAge = this.getCookieMaxAge();
        Integer other$cookieMaxAge = other.getCookieMaxAge();
        if (this$cookieMaxAge == null ? other$cookieMaxAge != null : !((Object)this$cookieMaxAge).equals(other$cookieMaxAge)) {
            return false;
        }
        Integer this$cookieTokenRenew = this.getCookieTokenRenew();
        Integer other$cookieTokenRenew = other.getCookieTokenRenew();
        if (this$cookieTokenRenew == null ? other$cookieTokenRenew != null : !((Object)this$cookieTokenRenew).equals(other$cookieTokenRenew)) {
            return false;
        }
        Integer this$rememberMeMaxSeconds = this.getRememberMeMaxSeconds();
        Integer other$rememberMeMaxSeconds = other.getRememberMeMaxSeconds();
        if (this$rememberMeMaxSeconds == null ? other$rememberMeMaxSeconds != null : !((Object)this$rememberMeMaxSeconds).equals(other$rememberMeMaxSeconds)) {
            return false;
        }
        Boolean this$enableLoginCaptcha = this.getEnableLoginCaptcha();
        Boolean other$enableLoginCaptcha = other.getEnableLoginCaptcha();
        if (this$enableLoginCaptcha == null ? other$enableLoginCaptcha != null : !((Object)this$enableLoginCaptcha).equals(other$enableLoginCaptcha)) {
            return false;
        }
        Boolean this$enableCsrf = this.getEnableCsrf();
        Boolean other$enableCsrf = other.getEnableCsrf();
        if (this$enableCsrf == null ? other$enableCsrf != null : !((Object)this$enableCsrf).equals(other$enableCsrf)) {
            return false;
        }
        Boolean this$corsAuth = this.getCorsAuth();
        Boolean other$corsAuth = other.getCorsAuth();
        if (this$corsAuth == null ? other$corsAuth != null : !((Object)this$corsAuth).equals(other$corsAuth)) {
            return false;
        }
        String this$authIdentityHeader = this.getAuthIdentityHeader();
        String other$authIdentityHeader = other.getAuthIdentityHeader();
        if (this$authIdentityHeader == null ? other$authIdentityHeader != null : !this$authIdentityHeader.equals(other$authIdentityHeader)) {
            return false;
        }
        String this$tokenExpirationReminderHeader = this.getTokenExpirationReminderHeader();
        String other$tokenExpirationReminderHeader = other.getTokenExpirationReminderHeader();
        if (this$tokenExpirationReminderHeader == null ? other$tokenExpirationReminderHeader != null : !this$tokenExpirationReminderHeader.equals(other$tokenExpirationReminderHeader)) {
            return false;
        }
        String this$tokenBalanceOutputHeader = this.getTokenBalanceOutputHeader();
        String other$tokenBalanceOutputHeader = other.getTokenBalanceOutputHeader();
        if (this$tokenBalanceOutputHeader == null ? other$tokenBalanceOutputHeader != null : !this$tokenBalanceOutputHeader.equals(other$tokenBalanceOutputHeader)) {
            return false;
        }
        String this$passwordMode = this.getPasswordMode();
        String other$passwordMode = other.getPasswordMode();
        if (this$passwordMode == null ? other$passwordMode != null : !this$passwordMode.equals(other$passwordMode)) {
            return false;
        }
        String this$tokenSecret = this.getTokenSecret();
        String other$tokenSecret = other.getTokenSecret();
        if (this$tokenSecret == null ? other$tokenSecret != null : !this$tokenSecret.equals(other$tokenSecret)) {
            return false;
        }
        String this$loginPath = this.getLoginPath();
        String other$loginPath = other.getLoginPath();
        if (this$loginPath == null ? other$loginPath != null : !this$loginPath.equals(other$loginPath)) {
            return false;
        }
        String this$logoutPath = this.getLogoutPath();
        String other$logoutPath = other.getLogoutPath();
        if (this$logoutPath == null ? other$logoutPath != null : !this$logoutPath.equals(other$logoutPath)) {
            return false;
        }
        String this$cookiePath = this.getCookiePath();
        String other$cookiePath = other.getCookiePath();
        if (this$cookiePath == null ? other$cookiePath != null : !this$cookiePath.equals(other$cookiePath)) {
            return false;
        }
        String this$cookieDomain = this.getCookieDomain();
        String other$cookieDomain = other.getCookieDomain();
        if (this$cookieDomain == null ? other$cookieDomain != null : !this$cookieDomain.equals(other$cookieDomain)) {
            return false;
        }
        String this$cookieSameSite = this.getCookieSameSite();
        String other$cookieSameSite = other.getCookieSameSite();
        if (this$cookieSameSite == null ? other$cookieSameSite != null : !this$cookieSameSite.equals(other$cookieSameSite)) {
            return false;
        }
        String this$tokenParamName = this.getTokenParamName();
        String other$tokenParamName = other.getTokenParamName();
        if (this$tokenParamName == null ? other$tokenParamName != null : !this$tokenParamName.equals(other$tokenParamName)) {
            return false;
        }
        String this$pathAuthList = this.getPathAuthList();
        String other$pathAuthList = other.getPathAuthList();
        if (this$pathAuthList == null ? other$pathAuthList != null : !this$pathAuthList.equals(other$pathAuthList)) {
            return false;
        }
        String this$pathAnonList = this.getPathAnonList();
        String other$pathAnonList = other.getPathAnonList();
        if (this$pathAnonList == null ? other$pathAnonList != null : !this$pathAnonList.equals(other$pathAnonList)) {
            return false;
        }
        String this$redirectOnAuthError = this.getRedirectOnAuthError();
        String other$redirectOnAuthError = other.getRedirectOnAuthError();
        if (this$redirectOnAuthError == null ? other$redirectOnAuthError != null : !this$redirectOnAuthError.equals(other$redirectOnAuthError)) {
            return false;
        }
        String this$redirectOnAuthFailed = this.getRedirectOnAuthFailed();
        String other$redirectOnAuthFailed = other.getRedirectOnAuthFailed();
        if (this$redirectOnAuthFailed == null ? other$redirectOnAuthFailed != null : !this$redirectOnAuthFailed.equals(other$redirectOnAuthFailed)) {
            return false;
        }
        String this$redirectOnAuthSuccess = this.getRedirectOnAuthSuccess();
        String other$redirectOnAuthSuccess = other.getRedirectOnAuthSuccess();
        if (this$redirectOnAuthSuccess == null ? other$redirectOnAuthSuccess != null : !this$redirectOnAuthSuccess.equals(other$redirectOnAuthSuccess)) {
            return false;
        }
        String this$redirectOnLogoutSuccess = this.getRedirectOnLogoutSuccess();
        String other$redirectOnLogoutSuccess = other.getRedirectOnLogoutSuccess();
        if (this$redirectOnLogoutSuccess == null ? other$redirectOnLogoutSuccess != null : !this$redirectOnLogoutSuccess.equals(other$redirectOnLogoutSuccess)) {
            return false;
        }
        String this$redirectOnNoAuth = this.getRedirectOnNoAuth();
        String other$redirectOnNoAuth = other.getRedirectOnNoAuth();
        if (this$redirectOnNoAuth == null ? other$redirectOnNoAuth != null : !this$redirectOnNoAuth.equals(other$redirectOnNoAuth)) {
            return false;
        }
        String this$redirectOnNoPermission = this.getRedirectOnNoPermission();
        String other$redirectOnNoPermission = other.getRedirectOnNoPermission();
        return !(this$redirectOnNoPermission == null ? other$redirectOnNoPermission != null : !this$redirectOnNoPermission.equals(other$redirectOnNoPermission));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SecurityConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $tokenExpirationReminderSeconds = this.getTokenExpirationReminderSeconds();
        result = result * 59 + ($tokenExpirationReminderSeconds == null ? 43 : ((Object)$tokenExpirationReminderSeconds).hashCode());
        Double $tokenExpirationReminderPercent = this.getTokenExpirationReminderPercent();
        result = result * 59 + ($tokenExpirationReminderPercent == null ? 43 : ((Object)$tokenExpirationReminderPercent).hashCode());
        Long $debugAccountId = this.getDebugAccountId();
        result = result * 59 + ($debugAccountId == null ? 43 : ((Object)$debugAccountId).hashCode());
        Integer $tokenSecretIndex = this.getTokenSecretIndex();
        result = result * 59 + ($tokenSecretIndex == null ? 43 : ((Object)$tokenSecretIndex).hashCode());
        Integer $tokenSeconds = this.getTokenSeconds();
        result = result * 59 + ($tokenSeconds == null ? 43 : ((Object)$tokenSeconds).hashCode());
        Boolean $enableBasicAuth = this.getEnableBasicAuth();
        result = result * 59 + ($enableBasicAuth == null ? 43 : ((Object)$enableBasicAuth).hashCode());
        Boolean $enableWwwAuthenticate = this.getEnableWwwAuthenticate();
        result = result * 59 + ($enableWwwAuthenticate == null ? 43 : ((Object)$enableWwwAuthenticate).hashCode());
        Boolean $enableBearerToken = this.getEnableBearerToken();
        result = result * 59 + ($enableBearerToken == null ? 43 : ((Object)$enableBearerToken).hashCode());
        Boolean $enable = this.getEnable();
        result = result * 59 + ($enable == null ? 43 : ((Object)$enable).hashCode());
        Boolean $cookieSecure = this.getCookieSecure();
        result = result * 59 + ($cookieSecure == null ? 43 : ((Object)$cookieSecure).hashCode());
        Boolean $cookieHttpOnly = this.getCookieHttpOnly();
        result = result * 59 + ($cookieHttpOnly == null ? 43 : ((Object)$cookieHttpOnly).hashCode());
        Integer $cookieMaxAge = this.getCookieMaxAge();
        result = result * 59 + ($cookieMaxAge == null ? 43 : ((Object)$cookieMaxAge).hashCode());
        Integer $cookieTokenRenew = this.getCookieTokenRenew();
        result = result * 59 + ($cookieTokenRenew == null ? 43 : ((Object)$cookieTokenRenew).hashCode());
        Integer $rememberMeMaxSeconds = this.getRememberMeMaxSeconds();
        result = result * 59 + ($rememberMeMaxSeconds == null ? 43 : ((Object)$rememberMeMaxSeconds).hashCode());
        Boolean $enableLoginCaptcha = this.getEnableLoginCaptcha();
        result = result * 59 + ($enableLoginCaptcha == null ? 43 : ((Object)$enableLoginCaptcha).hashCode());
        Boolean $enableCsrf = this.getEnableCsrf();
        result = result * 59 + ($enableCsrf == null ? 43 : ((Object)$enableCsrf).hashCode());
        Boolean $corsAuth = this.getCorsAuth();
        result = result * 59 + ($corsAuth == null ? 43 : ((Object)$corsAuth).hashCode());
        String $authIdentityHeader = this.getAuthIdentityHeader();
        result = result * 59 + ($authIdentityHeader == null ? 43 : $authIdentityHeader.hashCode());
        String $tokenExpirationReminderHeader = this.getTokenExpirationReminderHeader();
        result = result * 59 + ($tokenExpirationReminderHeader == null ? 43 : $tokenExpirationReminderHeader.hashCode());
        String $tokenBalanceOutputHeader = this.getTokenBalanceOutputHeader();
        result = result * 59 + ($tokenBalanceOutputHeader == null ? 43 : $tokenBalanceOutputHeader.hashCode());
        String $passwordMode = this.getPasswordMode();
        result = result * 59 + ($passwordMode == null ? 43 : $passwordMode.hashCode());
        String $tokenSecret = this.getTokenSecret();
        result = result * 59 + ($tokenSecret == null ? 43 : $tokenSecret.hashCode());
        String $loginPath = this.getLoginPath();
        result = result * 59 + ($loginPath == null ? 43 : $loginPath.hashCode());
        String $logoutPath = this.getLogoutPath();
        result = result * 59 + ($logoutPath == null ? 43 : $logoutPath.hashCode());
        String $cookiePath = this.getCookiePath();
        result = result * 59 + ($cookiePath == null ? 43 : $cookiePath.hashCode());
        String $cookieDomain = this.getCookieDomain();
        result = result * 59 + ($cookieDomain == null ? 43 : $cookieDomain.hashCode());
        String $cookieSameSite = this.getCookieSameSite();
        result = result * 59 + ($cookieSameSite == null ? 43 : $cookieSameSite.hashCode());
        String $tokenParamName = this.getTokenParamName();
        result = result * 59 + ($tokenParamName == null ? 43 : $tokenParamName.hashCode());
        String $pathAuthList = this.getPathAuthList();
        result = result * 59 + ($pathAuthList == null ? 43 : $pathAuthList.hashCode());
        String $pathAnonList = this.getPathAnonList();
        result = result * 59 + ($pathAnonList == null ? 43 : $pathAnonList.hashCode());
        String $redirectOnAuthError = this.getRedirectOnAuthError();
        result = result * 59 + ($redirectOnAuthError == null ? 43 : $redirectOnAuthError.hashCode());
        String $redirectOnAuthFailed = this.getRedirectOnAuthFailed();
        result = result * 59 + ($redirectOnAuthFailed == null ? 43 : $redirectOnAuthFailed.hashCode());
        String $redirectOnAuthSuccess = this.getRedirectOnAuthSuccess();
        result = result * 59 + ($redirectOnAuthSuccess == null ? 43 : $redirectOnAuthSuccess.hashCode());
        String $redirectOnLogoutSuccess = this.getRedirectOnLogoutSuccess();
        result = result * 59 + ($redirectOnLogoutSuccess == null ? 43 : $redirectOnLogoutSuccess.hashCode());
        String $redirectOnNoAuth = this.getRedirectOnNoAuth();
        result = result * 59 + ($redirectOnNoAuth == null ? 43 : $redirectOnNoAuth.hashCode());
        String $redirectOnNoPermission = this.getRedirectOnNoPermission();
        result = result * 59 + ($redirectOnNoPermission == null ? 43 : $redirectOnNoPermission.hashCode());
        return result;
    }

    public String toString() {
        return "SecurityConfig(authIdentityHeader=" + this.getAuthIdentityHeader() + ", tokenExpirationReminderSeconds=" + this.getTokenExpirationReminderSeconds() + ", tokenExpirationReminderPercent=" + this.getTokenExpirationReminderPercent() + ", tokenExpirationReminderHeader=" + this.getTokenExpirationReminderHeader() + ", tokenBalanceOutputHeader=" + this.getTokenBalanceOutputHeader() + ", debugAccountId=" + this.getDebugAccountId() + ", passwordMode=" + this.getPasswordMode() + ", tokenSecret=" + this.getTokenSecret() + ", tokenSecretIndex=" + this.getTokenSecretIndex() + ", tokenSeconds=" + this.getTokenSeconds() + ", loginPath=" + this.getLoginPath() + ", logoutPath=" + this.getLogoutPath() + ", enableBasicAuth=" + this.getEnableBasicAuth() + ", enableWwwAuthenticate=" + this.getEnableWwwAuthenticate() + ", enableBearerToken=" + this.getEnableBearerToken() + ", enable=" + this.getEnable() + ", cookiePath=" + this.getCookiePath() + ", cookieDomain=" + this.getCookieDomain() + ", cookieSecure=" + this.getCookieSecure() + ", cookieHttpOnly=" + this.getCookieHttpOnly() + ", cookieMaxAge=" + this.getCookieMaxAge() + ", cookieTokenRenew=" + this.getCookieTokenRenew() + ", cookieSameSite=" + this.getCookieSameSite() + ", tokenParamName=" + this.getTokenParamName() + ", rememberMeMaxSeconds=" + this.getRememberMeMaxSeconds() + ", enableLoginCaptcha=" + this.getEnableLoginCaptcha() + ", enableCsrf=" + this.getEnableCsrf() + ", pathAuthList=" + this.getPathAuthList() + ", pathAnonList=" + this.getPathAnonList() + ", redirectOnAuthError=" + this.getRedirectOnAuthError() + ", redirectOnAuthFailed=" + this.getRedirectOnAuthFailed() + ", redirectOnAuthSuccess=" + this.getRedirectOnAuthSuccess() + ", redirectOnLogoutSuccess=" + this.getRedirectOnLogoutSuccess() + ", redirectOnNoAuth=" + this.getRedirectOnNoAuth() + ", redirectOnNoPermission=" + this.getRedirectOnNoPermission() + ", corsAuth=" + this.getCorsAuth() + ")";
    }
}

