/*
 * Decompiled with CFR 0.152.
 */
package framework.config;

import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="sys.s3")
public class S3Config {
    private static final Logger log = LoggerFactory.getLogger(S3Config.class);
    private String name;
    private String accessKey;
    private String secretKey;
    private String region;
    private String bucket;
    private String endPoint;
    private Boolean pathStyle;
    private Boolean chunkedEncoding = true;
    private Integer saveMemoryMax = 0x1400000;
    private Integer partSize = 0xA00000;
    private String[] compressPathStarts;
    private String[] managers;

    public String getName() {
        return this.name;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getRegion() {
        return this.region;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getEndPoint() {
        return this.endPoint;
    }

    public Boolean getPathStyle() {
        return this.pathStyle;
    }

    public Boolean getChunkedEncoding() {
        return this.chunkedEncoding;
    }

    public Integer getSaveMemoryMax() {
        return this.saveMemoryMax;
    }

    public Integer getPartSize() {
        return this.partSize;
    }

    public String[] getCompressPathStarts() {
        return this.compressPathStarts;
    }

    public String[] getManagers() {
        return this.managers;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public void setEndPoint(String endPoint) {
        this.endPoint = endPoint;
    }

    public void setPathStyle(Boolean pathStyle) {
        this.pathStyle = pathStyle;
    }

    public void setChunkedEncoding(Boolean chunkedEncoding) {
        this.chunkedEncoding = chunkedEncoding;
    }

    public void setSaveMemoryMax(Integer saveMemoryMax) {
        this.saveMemoryMax = saveMemoryMax;
    }

    public void setPartSize(Integer partSize) {
        this.partSize = partSize;
    }

    public void setCompressPathStarts(String[] compressPathStarts) {
        this.compressPathStarts = compressPathStarts;
    }

    public void setManagers(String[] managers) {
        this.managers = managers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof S3Config)) {
            return false;
        }
        S3Config other = (S3Config)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$pathStyle = this.getPathStyle();
        Boolean other$pathStyle = other.getPathStyle();
        if (this$pathStyle == null ? other$pathStyle != null : !((Object)this$pathStyle).equals(other$pathStyle)) {
            return false;
        }
        Boolean this$chunkedEncoding = this.getChunkedEncoding();
        Boolean other$chunkedEncoding = other.getChunkedEncoding();
        if (this$chunkedEncoding == null ? other$chunkedEncoding != null : !((Object)this$chunkedEncoding).equals(other$chunkedEncoding)) {
            return false;
        }
        Integer this$saveMemoryMax = this.getSaveMemoryMax();
        Integer other$saveMemoryMax = other.getSaveMemoryMax();
        if (this$saveMemoryMax == null ? other$saveMemoryMax != null : !((Object)this$saveMemoryMax).equals(other$saveMemoryMax)) {
            return false;
        }
        Integer this$partSize = this.getPartSize();
        Integer other$partSize = other.getPartSize();
        if (this$partSize == null ? other$partSize != null : !((Object)this$partSize).equals(other$partSize)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$accessKey = this.getAccessKey();
        String other$accessKey = other.getAccessKey();
        if (this$accessKey == null ? other$accessKey != null : !this$accessKey.equals(other$accessKey)) {
            return false;
        }
        String this$secretKey = this.getSecretKey();
        String other$secretKey = other.getSecretKey();
        if (this$secretKey == null ? other$secretKey != null : !this$secretKey.equals(other$secretKey)) {
            return false;
        }
        String this$region = this.getRegion();
        String other$region = other.getRegion();
        if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
            return false;
        }
        String this$bucket = this.getBucket();
        String other$bucket = other.getBucket();
        if (this$bucket == null ? other$bucket != null : !this$bucket.equals(other$bucket)) {
            return false;
        }
        String this$endPoint = this.getEndPoint();
        String other$endPoint = other.getEndPoint();
        if (this$endPoint == null ? other$endPoint != null : !this$endPoint.equals(other$endPoint)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getCompressPathStarts(), other.getCompressPathStarts())) {
            return false;
        }
        return Arrays.deepEquals(this.getManagers(), other.getManagers());
    }

    protected boolean canEqual(Object other) {
        return other instanceof S3Config;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $pathStyle = this.getPathStyle();
        result = result * 59 + ($pathStyle == null ? 43 : ((Object)$pathStyle).hashCode());
        Boolean $chunkedEncoding = this.getChunkedEncoding();
        result = result * 59 + ($chunkedEncoding == null ? 43 : ((Object)$chunkedEncoding).hashCode());
        Integer $saveMemoryMax = this.getSaveMemoryMax();
        result = result * 59 + ($saveMemoryMax == null ? 43 : ((Object)$saveMemoryMax).hashCode());
        Integer $partSize = this.getPartSize();
        result = result * 59 + ($partSize == null ? 43 : ((Object)$partSize).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $accessKey = this.getAccessKey();
        result = result * 59 + ($accessKey == null ? 43 : $accessKey.hashCode());
        String $secretKey = this.getSecretKey();
        result = result * 59 + ($secretKey == null ? 43 : $secretKey.hashCode());
        String $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        String $bucket = this.getBucket();
        result = result * 59 + ($bucket == null ? 43 : $bucket.hashCode());
        String $endPoint = this.getEndPoint();
        result = result * 59 + ($endPoint == null ? 43 : $endPoint.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getCompressPathStarts());
        result = result * 59 + Arrays.deepHashCode(this.getManagers());
        return result;
    }

    public String toString() {
        return "S3Config(name=" + this.getName() + ", accessKey=" + this.getAccessKey() + ", secretKey=" + this.getSecretKey() + ", region=" + this.getRegion() + ", bucket=" + this.getBucket() + ", endPoint=" + this.getEndPoint() + ", pathStyle=" + this.getPathStyle() + ", chunkedEncoding=" + this.getChunkedEncoding() + ", saveMemoryMax=" + this.getSaveMemoryMax() + ", partSize=" + this.getPartSize() + ", compressPathStarts=" + Arrays.deepToString(this.getCompressPathStarts()) + ", managers=" + Arrays.deepToString(this.getManagers()) + ")";
    }
}

